% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw-methods.R
\name{draw.derivatives}
\alias{draw.derivatives}
\title{Plot derivatives of smooths}
\usage{
\method{draw}{derivatives}(
  object,
  select = NULL,
  scales = c("free", "fixed"),
  alpha = 0.2,
  ncol = NULL,
  nrow = NULL,
  guides = "keep",
  ...
)
}
\arguments{
\item{object}{a fitted GAM, the result of a call to \code{\link[mgcv:gam]{mgcv::gam()}}.}

\item{select}{character, logical, or numeric; which smooths to plot. If
\code{NULL}, the default, then all model smooths are drawn. Numeric \code{select}
indexes the smooths in the order they are specified in the formula and
stored in \code{object}. Character \code{select} matches the labels for smooths
as shown for example in the output from \code{summary(object)}. Logical
\code{select} operates as per numeric \code{select} in the order that smooths are
stored.}

\item{scales}{character; should all univariate smooths be plotted with the
same y-axis scale? The default, \code{scales = "fixed"}, ensures this is done.
If \code{scales = "free"} each univariate smooth has its own y-axis scale.
Currently does not affect the y-axis scale of plots of the parametric
terms.}

\item{alpha}{numeric; alpha transparency for confidence or simultaneous
interval.}

\item{ncol}{numeric; the numbers of rows and columns over which to
spread the plots}

\item{nrow}{numeric; the numbers of rows and columns over which to
spread the plots}

\item{guides}{character; one of \code{"keep"} (the default), \code{"collect"}, or
\code{"auto"}. Passed to \code{\link[patchwork:plot_layout]{patchwork::plot_layout()}}}

\item{...}{additional arguments passed to \code{\link[patchwork:wrap_plots]{patchwork::wrap_plots()}}.}
}
\description{
Plot derivatives of smooths
}
\examples{

load_mgcv()
dat <- data_sim("eg1", n = 800, dist = "normal", scale = 2, seed = 42)
mod <- gam(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = dat, method = "REML")

## first derivative of all smooths
df <- derivatives(mod, type = "central")
draw(df)
## fixed axis scales
draw(df, scales = "fixed")
}
