% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graticule.R
\docType{package}
\name{graticule}
\alias{graticule}
\title{graticule: graticule lines for maps}
\usage{
graticule(lons, lats, nverts = NULL, xlim, ylim, proj = NULL, tiles = FALSE)
}
\arguments{
\item{lons}{longitudes for meridional lines}

\item{lats}{latitudes for parallel lines}

\item{nverts}{number of discrete vertices for each segment}

\item{xlim}{maximum range of parallel lines}

\item{ylim}{maximum range of meridional lines}

\item{proj}{optional proj.4 string for output object}

\item{tiles}{if \code{TRUE} return polygons as output}
}
\value{
SpatialLines or SpatialPolygons object
}
\description{
Specify the creation of lines along meridians by specifying their placement
at particular \code{lons} (longitudes) and \code{lats} (latitudes) and their extents
with \code{xlim} (extent of parallel line in longitude) and \code{ylim} (extent of meridional line in latitude).
}
\details{
Provide a valid PROJ.4 string to return the graticule lines in this projection. If this is not specified the graticule
lines are returned in their original longlat / WGS84.
All segments are discretized as _rhumb_lines_ at `getOption("graticule.mindist")` metres, which
defaults to `5e4`.
The arguments \code{xlim}, \code{ylim} and \code{nverts} are ignored if \code{tiles} is \code{TRUE}.
}
\examples{
graticule()
}
