% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/youth_unemployment.R
\name{youth_unemployment}
\alias{youth_unemployment}
\title{Youth unemployment}
\usage{
youth_unemployment(income = 0, assets = 0, fy.year = NULL,
  Date = NULL, has_partner = FALSE, has_dependant = FALSE,
  age = 23, lives_at_home = FALSE, independent = TRUE,
  unemployed = FALSE)
}
\arguments{
\item{income}{Numeric vector of fortnightly income for the income test.}

\item{assets}{Numeric vector of the value of assets. By default, \code{income} and \code{assets} are both zero, thus returning the maximum benefit payable.}

\item{fy.year}{A character vector of valid financial years between "2000-01" and "2020-21" specifying which financial year the allowance is to be calculated.}

\item{Date}{(Date vector or coercible to such). An alternative to \code{fy.year} to specify the period over which the allowance is calculated.}

\item{has_partner}{(logical, default: \code{FALSE}) Does the individual have a partner?}

\item{has_dependant}{(logical, default: \code{FALSE}) Does the indvidiual have any dependant children?}

\item{age}{Age (only determines whether the 16-17 age or 18 or over rates will apply).}

\item{lives_at_home}{(logical, default: \code{FALSE}) Is the individual a dependant who lives at home?}

\item{independent}{(logical, default: \code{TRUE}) Should the individual be considered independent.}

\item{unemployed}{(logical, default: \code{FALSE}) Is the individual unemployed?}
}
\value{
The fortnightly unemployment benefit payable for each entry. 
The function is vectorized over its arguments, with any length-1 argument
recycled. (Other vector recycling is not supported and will result in an error.)
}
\description{
Youth unemployment
}
