% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_per.R
\name{validate_per}
\alias{validate_per}
\title{Validate per}
\usage{
validate_per(per, missing_per, .fortnights_per_yr = 26)
}
\arguments{
\item{per}{How often are payments made? Can only take values 'year', 'fortnight', or 'quarter'.}

\item{missing_per}{Is `per` missing in the outer function? If so the default 
for that function will be used. Essentially, you should always pass 
\code{missing(per)} to this argument.}

\item{.fortnights_per_yr}{What is the ratio of the fortnightly payment amount
to the yearly payment amount? By default, 26. 
(Some payments expect 26; others expect 364/14.)}
}
\description{
Checks whether a valid input of `per` is used and outputs the amount which 
yearly payments are divided by to get the desired rate.
}
\details{
For examples, see \code{\link{rent_assistance}} function code.
}
\examples{
\dontrun{
# Typical use-case
# attach(asNamespace("grattan"))
z <- function(per = "year") 52 / validate_per(per, missing(per))
z()  # message
z(per = "year")       # same, no message
z(per = "fortnight")  # in fortnights
z(per = "sidfh")      # error
}


}
