% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wage_inflator.R
\name{wage_inflator}
\alias{wage_inflator}
\title{Wage inflator}
\usage{
wage_inflator(
  from = NULL,
  to = NULL,
  check = 1L,
  x = NULL,
  nThread = getOption("grattanInflators.nThread", 1L)
)
}
\arguments{
\item{from, to}{Times for which the inflator is desired. If \code{NULL}, a date
range close to the previous year is used.}

\item{check}{\code{integer(1)} If \code{0L}, no checks are performed, and
clearly invalid inputs result in \code{NA} in the output. If \code{check = 1L}
an error is performed for bad input; \code{check = 2L} is more thorough.}

\item{x}{(Advanced) A vector that will be inflated in-place. If \code{NULL},
the default, the return vector is simply the inflation factor for `from`.}

\item{nThread}{Number of threads to use.}
}
\value{
If `x` is `NULL`, the default, a numeric vector matching the lengths of `from`
and `to` equal to the inflators by which nominal wages dated `from` must be
multiplied so that they are in `to` real terms.

If `x` is numeric, it is taken to be wages dated `from` and the value returned
is `x` in `to` real terms.
}
\description{
Uses the Wage Price Index
}
