% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_distance.R
\name{calculate_between_sample_distance}
\alias{calculate_between_sample_distance}
\title{Calculate distance between sample data before and after registration}
\usage{
calculate_between_sample_distance(
  mean_df,
  mean_df_sc,
  imputed_mean_df,
  gene_col = "locus_name",
  compare_ref_vs_transform = TRUE,
  accession_data_ref
)
}
\arguments{
\item{mean_df}{Input data frame contains the mean gene expression of each gene in each genotype at each time point.}

\item{mean_df_sc}{Input data frame which is identical to \code{mean_df}, with additional column \code{sc.expression_value} which is scaled of expression values.}

\item{imputed_mean_df}{Input data frame contains registered.}

\item{gene_col}{Column name of gene accession, default is \code{locus_name}.}

\item{compare_ref_vs_transform}{If \code{TRUE}, the default, only comparison between reference data and data to transform is considered.}

\item{accession_data_ref}{Accession name of reference data.}
}
\value{
This function returns a list of data frames which includes:
\item{distance_mean_df}{distance of mean expression values.}
\item{distance_scaled_mean_df}{distance of scaled mean expression (all genes).}
\item{distance_scaled_mean_df_only_nonreg}{distance of scaled mean expression (only non-registered genes).}
\item{distance_scaled_mean_df_only_reg}{distance of scaled mean expression (only registered genes).}
\item{distance_registered_df}{distance of registered & scaled mean expression (all genes).}
\item{distance_registered_df_only_reg}{distance of registered & scaled mean expression (only registered genes).}
}
\description{
Calculate distance between sample data before and after registration
}
