% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze_green_and_tree_count_density.R
\name{analyze_green_and_tree_count_density}
\alias{analyze_green_and_tree_count_density}
\title{Analyze Green Space or Tree Count Density with Research Metrics and Lorenz Curve}
\usage{
analyze_green_and_tree_count_density(
  osm_data,
  mode = c("green_area", "tree_density"),
  h3_res = 8,
  color_palette = c("#FFEDA0", "#74C476", "#005A32"),
  opacity = 0.7,
  tile_provider = c("OpenStreetMap", "Positron", "DarkMatter", "Esri.WorldImagery"),
  enable_hover = TRUE,
  categorization_method = c("quantile", "jenks", "fixed"),
  fixed_breaks = NULL,
  save_html = FALSE,
  html_map_path = "density_map.html",
  save_json = FALSE,
  json_file = "density_data.json",
  save_lorenz = FALSE,
  lorenz_plot_path = "lorenz_curve.png"
)
}
\arguments{
\item{osm_data}{Output from \code{get_osm_data()}, containing at least
\code{osm_data$green_areas$osm_polygons} or \code{osm_data$trees$osm_points}.}

\item{mode}{Character. Either \code{"green_area"} (green polygon count) or
\code{"tree_density"} (point count). Default: \code{"green_area"}.}

\item{h3_res}{Integer. H3 resolution (0–15). Default = 8.}

\item{color_palette}{Character vector of 3 colors for choropleth. Default =
\code{c("#FFEDA0", "#74C476", "#005A32")}.}

\item{opacity}{Numeric. Fill opacity for hexes. Default = 0.7.}

\item{tile_provider}{Character. One of
\code{c("OpenStreetMap", "Positron", "DarkMatter", "Esri.WorldImagery")}.
Default = \code{"OpenStreetMap"}.}

\item{enable_hover}{Logical. Show hover labels. Default = \code{TRUE}.}

\item{categorization_method}{Character. One of
\code{c("quantile", "jenks", "fixed")}. Default = \code{"quantile"}.}

\item{fixed_breaks}{Numeric vector of length 2. Thresholds for "fixed" method.
Default = \code{NULL}.}

\item{save_html}{Logical. Save map as self-contained HTML. Default = \code{FALSE}.}

\item{html_map_path}{Character. Filepath for HTML. Default = \code{"density_map.html"}.}

\item{save_json}{Logical. Save hex centroid + value JSON. Default = \code{FALSE}.}

\item{json_file}{Character. Filepath for JSON. Default = \code{"density_data.json"}.}

\item{save_lorenz}{Logical. Save Lorenz curve PNG. Default = \code{FALSE}.}

\item{lorenz_plot_path}{Character. Filepath for Lorenz PNG. Default =
\code{"lorenz_curve.png"}.}
}
\value{
A list with:
\item{map}{Leaflet map object}
\item{analytics}{Named list of summary statistics}
\item{json_file}{Path to JSON file (if saved)}
\item{lorenz_plot}{Path to Lorenz PNG (if saved)}
}
\description{
This function analyzes the spatial distribution of green spaces or trees using counts per hexagon,
avoiding unreliable area estimates. It calculates inequality and distribution metrics and produces
an interactive map, analytics, and optional Lorenz curve and JSON export. Automatically selects binning
strategy if data are too sparse for quantile or Jenks categorization.
}
\examples{
\dontrun{
# Example: green area polygons (default mode)
osm_data <- get_osm_data("Zurich, Switzerland", features = c("green_areas", "trees"))
result <- analyze_green_and_tree_count_density(
  osm_data = osm_data,
  mode = "green_area",
  h3_res = 8,
  save_lorenz = TRUE
)
print(result$analytics)
result$map
result$lorenz_plot

# Example: tree density
result2 <- analyze_green_and_tree_count_density(
  osm_data = osm_data,
  mode = "tree_density",
  h3_res = 8,
  color_palette = c("#F0E442", "#009E73", "#D55E00"),
  save_html = TRUE
)
result2$map
}
}
