% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{process_rfid_data}
\alias{process_rfid_data}
\title{Process RFID Data}
\usage{
process_rfid_data(rfid_file)
}
\arguments{
\item{rfid_file}{Path or data frame containing RFID data.}
}
\value{
A data frame with standardized column names (`FarmName` and `RFID`). If the input is invalid or if no valid data is provided, the function returns `NULL`.
}
\description{
Processes RFID data from animals in the study.
}
\examples{
# Example with a data frame
df <- data.frame(
  V1 = c("Farm1", "Farm2", "Farm3"),
  V2 = c("12345", "67890", "54321")
)
processed_df <- process_rfid_data(df)
message(processed_df)

# Example with invalid input
invalid_data <- process_rfid_data(NULL)
# Expected output: message "RFID is NA. It is recommended to include it." and NULL
message(invalid_data)

# Example with unsupported file format
# Assuming 'rfid_data.docx' is an unsupported file format
invalid_file <- process_rfid_data("path/to/rfid_data.docx")
# Expected output: error message "Unsupported file format."
message(invalid_file)

}
\keyword{internal}
