% Generated by roxygen2 (4.0.2): do not edit by hand
\name{eReport}
\alias{eReport}
\title{Event Report}
\usage{
eReport(formula, data = NULL, subset = NULL, na.action = na.retain,
  minincidence = 0, conf.int = 0.95, etype = "adverse events",
  panel = "events", subpanel = NULL, head = NULL, tail = NULL, h = 6,
  w = 7, append = FALSE, popts = NULL)
}
\arguments{
\item{formula}{a formula with one or two left hand variables (the first representing major categorization and the second minor), and 1-2 right hand variables.  One of these may be enclosed in \code{id()} to indicate the presence of a unique subject ID, and the other is treatment.}

\item{data}{input data frame}

\item{subset}{subsetting criteria}

\item{na.action}{function for handling \code{NA}s when creating analysis frame}

\item{minincidence}{a number between 0 and 1 specifying the minimum incidence in any stratum that must hold before an event is included in the summary}

\item{conf.int}{confidence level for difference in proportions}

\item{etype}{a character string describing the nature of the events, for example \code{"adverse events"}, \code{"serious adverse events"}.  Used in figure captions.}

\item{panel}{panel string}

\item{subpanel}{a subpanel designation to add to \code{panel}}

\item{head}{character string.  Specifies initial text in the figure caption, otherwise a default is used.}

\item{tail}{a character string to add to end of automatic caption}

\item{h}{height of graph}

\item{w}{width of graph}

\item{append}{set to \code{TRUE} if adding to an existing sub-report}

\item{popts}{a list of options to pass to graphing functions}
}
\description{
Generates graphics for binary event proportions
}
\details{
Generates dot charts showing proportions on left and risk difference with confidence intervals on the right, if there is only one level of event categorization.  Input data must contain one record per event, with this record containing the event name.  If there is more than one event of a given type per subject, unique subject ID must be provided.  Denominators come from \code{greport} options and it is assumed that only randomized subjects have records.  Some of the graphics functions are modifications of those found in the HH package.  The data are expected to have one record per event, and non-events are inferred from \code{setgreportOption('denom')}.  It is also assumed that only randomized subjects are included in the dataset.
}
\examples{
# See test.Rnw in tests directory
}
\author{
Frank Harrell
}

