% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iterate_dynamic_matrix.R
\name{iterate_dynamic_matrix}
\alias{iterate_dynamic_matrix}
\title{iterate dynamic transition matrices}
\usage{
iterate_dynamic_matrix(
  matrix_function,
  initial_state,
  niter,
  tol,
  ...,
  state_limits = c(-Inf, Inf)
)
}
\arguments{
\item{matrix_function}{a function taking in the previous population state and
the current iteration (and possibly other greta arrays) and returning a
transition matrix to use for this iteration. The first two arguments must
be named 'state' and 'iter', the state vector and scalar iteration number
respectively. The remaining parameters must be named arguments representing
(temporally static) model parameters. Variables and distributions cannot be
defined inside the function.}

\item{initial_state}{either a column vector (with m elements) or a 3D array
(with dimensions n x m x 1) giving one or more initial states from which to
iterate the matrix}

\item{niter}{a positive integer giving the maximum number of times to iterate
the matrix}

\item{tol}{a scalar giving a numerical tolerance, below which the algorithm
is determined to have converged to a stable population size in all stages}

\item{...}{optional named arguments to \code{matrix_function}, giving greta
arrays for additional parameters}

\item{state_limits}{a numeric vector of length 2 giving minimum and maximum
values at which to clamp the values of state after each iteration to
prevent numerical under/overflow; i.e. elements with values below the
minimum (maximum) will be set to the minimum (maximum).}
}
\value{
a named list with four greta arrays:
\itemize{
\item \code{stable_state} a vector or matrix (with the same dimensions as
\code{initial_state}) giving the state after the final iteration.
\item \code{all_states} an n x m x niter matrix of the state values at
each iteration. This will be 0 for all entries after \code{iterations}.
\item \code{converged} an integer scalar indicating whether \emph{all}
the matrix iterations converged to a tolerance less than \code{tol} (1 if
so, 0 if not) before the algorithm finished.
\item \code{iterations} a scalar of the maximum number of iterations
completed before the algorithm terminated. This should match \code{niter}
if \code{converged} is \code{FALSE}
}
}
\description{
Calculate the stable population size for a stage-structured
dynamical system, encoded by a transition matrix, the value of which
changes at each iteration, given by function of the previous state:
\code{state[t] = f(state[t-1]) \%*\% state[t-1]}.
}
\details{
Because \code{iterate_matrix} iterates with a static transition
matrix, it converges to a stable \emph{growth rate} and \emph{relative}
population sizes for a dynamical system. \code{iterate_dynamic_matrix}
instead uses a matrix which changes at each iteration, and can be dependent
on the population sizes after the previous iteration, and the iteration
number. Because this can encode density-dependence, the dynamics can
converge to \emph{absolute} population sizes. The convergence criterion is
therefore based on growth rates converging on 0.

As in \code{iterate_matrix}, the greta array returned by
\code{matrix_function} can either be a square matrix, or a 3D array
representing (on the first dimension) \emph{n} different matrices.
\code{initial_state} should be shaped accordingly, as detailed in
\code{iterate_matrix}.

To ensure the matrix is iterated for a specific number of iterations, you
can set that number as \code{niter}, and set \code{tol} to 0 or a negative
number to ensure that the iterations are not stopped early.
}
\note{
because greta vectorises across both MCMC chains and the calculation of
greta array values, the algorithm is run until all chains (or posterior
samples), sites and stages have converged to stable growth. So a single
value of both \code{converged} and \code{iterations} is returned, and the
value of this will always have the same value in an \code{mcmc.list} object. So
inspecting the MCMC trace of these parameters will only tell you whether
the iteration converged in \emph{all} posterior samples, and the maximum
number of iterations required to do so across all these samples
}
