% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exec_inp.R
\name{exec_inp}
\alias{exec_inp}
\title{Execute  existing \code{gretl} \code{inp} file(s) in R}
\usage{
exec_inp(path=".")
}
\arguments{
\item{path}{Object or a character string representing the path(s) to the \code{gretl} file(s). (default: \code{"."})}
}
\value{
Set of \code{gretl} (open-source software for Econometrics) outputs
}
\description{
Use this function to execute existing \code{gretl} \code{inp} file(s) in R
}
\examples{
library(gretlR)
\dontrun{
code=r'(nulldata 500
set seed 13
gretl1 = normal()
gretl2 = normal()
setobs 12 1980:01 --time-series
gnuplot gretl1 --time-series --with-lines --output="line.png"
gnuplot gretl2 gretl1 --output="scatter.png"
)'
write_inp(code,path="SomeFolder/gretlCodes")
exec_inp("someFolder/gretlCodes")

}
}
\seealso{
Other important functions: 
\code{\link{eng_gretl}()},
\code{\link{exec_gretl}()},
\code{\link{gretlR}},
\code{\link{import_kable}()},
\code{\link{include_graph}()},
\code{\link{include_tex}()},
\code{\link{write_inp}()}
}
\concept{important functions}
\keyword{documentation}
