% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{predict.alm}
\alias{predict.alm}
\alias{predict.greybox}
\alias{forecast}
\alias{forecast.greybox}
\alias{predict.scale}
\alias{forecast.alm}
\title{Forecasting using greybox functions}
\usage{
\method{predict}{alm}(object, newdata = NULL, interval = c("none",
  "confidence", "prediction"), level = 0.95, side = c("both", "upper",
  "lower"), ...)

\method{predict}{greybox}(object, newdata = NULL, interval = c("none",
  "confidence", "prediction"), level = 0.95, side = c("both", "upper",
  "lower"), ...)

\method{predict}{scale}(object, newdata = NULL, interval = c("none",
  "confidence", "prediction"), level = 0.95, side = c("both", "upper",
  "lower"), ...)

\method{forecast}{greybox}(object, newdata = NULL, h = NULL, ...)

\method{forecast}{alm}(object, newdata = NULL, h = NULL, ...)
}
\arguments{
\item{object}{Time series model for which forecasts are required.}

\item{newdata}{The new data needed in order to produce forecasts.}

\item{interval}{Type of intervals to construct: either "confidence" or
"prediction". Can be abbreviated}

\item{level}{Confidence level. Defines width of prediction interval.}

\item{side}{What type of interval to produce: \code{"both"} - produces both
lower and upper bounds of the interval, \code{"upper"} - upper only, \code{"lower"}
- respectively lower only. In the \code{"both"} case the probability is split into
two parts: ((1-level)/2, (1+level)/2). When \code{"upper"} is specified, then
the intervals for (0, level) are constructed Finally, with \code{"lower"} the interval
for (1-level, 1) is returned.}

\item{...}{Other arguments passed to \code{vcov} function (see \link[greybox]{coef.alm}
for details).}

\item{h}{The forecast horizon.}
}
\value{
\code{predict.greybox()} returns object of class "predict.greybox",
which contains:
\itemize{
\item \code{model} - the estimated model.
\item \code{mean} - the expected values.
\item \code{fitted} - fitted values of the model.
\item \code{lower} - lower bound of prediction / confidence intervals.
\item \code{upper} - upper bound of prediction / confidence intervals.
\item \code{level} - confidence level.
\item \code{newdata} - the data provided in the call to the function.
\item \code{variances} - conditional variance for the holdout sample.
In case of \code{interval="prediction"} includes variance of the error.
}

\code{predict.alm()} is based on \code{predict.greybox()} and returns
object of class "predict.alm", which in addition contains:
\itemize{
\item \code{location} - the location parameter of the distribution.
\item \code{scale} - the scale parameter of the distribution.
\item \code{distribution} - name of the fitted distribution.
}

\code{forecast()} functions return the same "predict.alm" and
"predict.greybox" classes, with the same set of output variables.
}
\description{
The functions allow producing forecasts based on the provided model and newdata.
}
\details{
\code{predict} produces predictions for the provided model and \code{newdata}. If
\code{newdata} is not provided, then the data from the model is extracted and the
fitted values are reproduced. This might be useful when confidence / prediction
intervals are needed for the in-sample values.

\code{forecast} function produces forecasts for \code{h} steps ahead. There are four
scenarios in this function:
\enumerate{
\item If the \code{newdata} is  not provided, then it will produce forecasts of the
explanatory variables to the horizon \code{h} (using \code{es} from smooth package
or using Naive if \code{smooth} is not installed) and use them as \code{newdata}.
\item If \code{h} and \code{newdata} are provided, then the number of rows to use
will be regulated by \code{h}.
\item If \code{h} is \code{NULL}, then it is set equal to the number of rows in
\code{newdata}.
\item If both \code{h} and \code{newdata} are not provided, then it will use the
data from the model itself, reproducing the fitted values.
}
After forming the \code{newdata} the \code{forecast} function calls for
\code{predict}, so you can provide parameters \code{interval}, \code{level} and
\code{side} in the call for \code{forecast}.
}
\examples{

xreg <- cbind(rlaplace(100,10,3),rnorm(100,50,5))
xreg <- cbind(100+0.5*xreg[,1]-0.75*xreg[,2]+rlaplace(100,0,3),xreg,rnorm(100,300,10))
colnames(xreg) <- c("y","x1","x2","Noise")
inSample <- xreg[1:80,]
outSample <- xreg[-c(1:80),]

ourModel <- alm(y~x1+x2, inSample, distribution="dlaplace")

predict(ourModel,outSample)
predict(ourModel,outSample,interval="c")

plot(predict(ourModel,outSample,interval="p"))
plot(forecast(ourModel,h=10,interval="p"))

}
\seealso{
\link[stats]{predict.lm}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{ts}
\keyword{univar}
