% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pattern-geometry-tiling.R
\docType{data}
\name{grid.pattern_polygon_tiling}
\alias{grid.pattern_polygon_tiling}
\alias{names_polygon_tiling}
\title{Polygon tiling patterned grobs}
\format{
An object of class \code{character} of length 36.
}
\usage{
grid.pattern_polygon_tiling(
  x = c(0, 0, 1, 1),
  y = c(1, 0, 0, 1),
  id = 1L,
  ...,
  colour = gp$col \%||\% "grey20",
  fill = gp$fill \%||\% "grey80",
  angle = 30,
  spacing = 0.05,
  xoffset = 0,
  yoffset = 0,
  type = "square",
  alpha = gp$alpha \%||\% NA_real_,
  linetype = gp$lty \%||\% 1,
  linewidth = size \%||\% gp$lwd \%||\% 1,
  size = NULL,
  default.units = "npc",
  name = NULL,
  gp = gpar(),
  draw = TRUE,
  vp = NULL
)

names_polygon_tiling
}
\arguments{
\item{x}{A numeric vector or unit object specifying x-locations of the pattern boundary.}

\item{y}{A numeric vector or unit object specifying y-locations of the pattern boundary.}

\item{id}{A numeric vector used to separate locations in x, y into multiple boundaries.
All locations within the same \code{id} belong to the same boundary.}

\item{...}{Currently ignored}

\item{colour}{Stroke colour}

\item{fill}{Fill colour}

\item{angle}{Rotation angle in degrees}

\item{spacing}{Spacing between repetitions of pattern ('snpc' units between 0 and 1).}

\item{xoffset}{Shift pattern along x axis ('snpc' units between 0 and 1).}

\item{yoffset}{Shift pattern along y axis ('snpc' units between 0 and 1).}

\item{type}{Name of polygon tiling to draw.  See Details.}

\item{alpha}{Alpha (between 0 and 1) or \code{NA} (default, preserves colors' alpha value).
Not supported for all polygon tiling \code{type}.}

\item{linetype}{Stroke linetype}

\item{linewidth}{Stroke linewidth}

\item{size}{For backwards compatibility can be used to set \code{linewidth}}

\item{default.units}{A string indicating the default units to use if \code{x} or \code{y}
are only given as numeric vectors.}

\item{name}{ A character identifier. }

\item{gp}{An object of class \code{"gpar"}, typically the output
    from a call to the function \code{\link[grid]{gpar}}.  This is basically
    a list of graphical parameter settings.}

\item{draw}{A logical value indicating whether graphics output
    should be produced.}

\item{vp}{A Grid viewport object (or NULL).}
}
\value{
A grid grob object invisibly.  If \code{draw} is \code{TRUE} then also draws to the graphic device as a side effect.
}
\description{
\code{grid.pattern_polygon_tiling()} draws a specified polygon tiling pattern onto the graphic device.
\code{names_polygon_tiling} lists all supported types.
}
\details{
\code{grid.pattern_polygon_tiling()} supports 1, 2, or 3 \code{fill} colors with the first colors (weakly)
covering a larger area.  Size of the pattern is controlled by \code{spacing}.
We support the following polygon tiling \code{type}s:

\describe{
\item{\code{elongated_triangular}}{Creates an elongated triangular tiling made of squares and triangles.}
\item{\code{herringbone}}{Creates a herringbone tiling made of rectangles.}
\item{\code{hexagonal}}{Creates a hexagonal tiling made of hexagons.}
\item{\code{pythagorean}}{Creates a Pythagorean tiling made of squares of two different sizes.}
\item{\code{rhombille}}{Creates a rhombille tiling made of rhombi.}
\item{\code{rhombitrihexagonal}}{Creates a rhombitrihexagonal tiling made out of
dodecagons, hexagons, and squares.}
\item{\code{snub_square}}{Creates a snub square tiling made of squares and triangles.}
\item{\code{snub_trihexagonal}}{Creates a snub trihexagonal tiling made of hexagons and triangles.}
\item{\code{square}}{Creates a square tiling made of squares.}
\item{\code{tetrakis_square}}{Creates a tetrakis square tiling made of isosceles right triangles.}
\item{\code{triangular}}{Creates a triangular tiling made of equilateral triangles.}
\item{\code{trihexagonal}}{Creates a trihexagonal tiling made of hexagons and triangles.}
\item{\code{truncated_square}}{Creates a truncated square tiling made of octagons and squares.}
\item{\code{truncated_hexagonal}}{Creates a truncated hexagonal tiling made of dodecagons and triangles.}
\item{\code{truncated_trihexagonal}}{Creates a truncated trihexagonal tiling made of hexagons, squares, and triangles.}
\item{\verb{2*.2**.2*.2**}}{Creates a polygon tiling made of rhombi.}
\item{\verb{2**.3**.12*}}{Creates a polygon tiling made of rhombi, triangles, and twelve-pointed stars.}
\item{\verb{3.3.3.3**}}{Creates a polygon tiling made of triangles.}
\item{\verb{3.3*.3.3**}}{Creates a regular (star) polygon tiling made of triangles and three-pointed stars.}
\item{\verb{3.3.3.12*.3.3.12*}}{Creates a regular (star) polygon tiling made of triangles and twelve-pointed stars.}
\item{\verb{3.3.8*.3.4.3.8*}}{Creates a regular (star) polygon tiling made of triangles, squares, and eight-pointed stars.}
\item{\verb{3.3.8*.4**.8*}}{Creates a regular (star) polygon tiling made of triangles, four-pointed stars, and eight-pointed stars.}
\item{\verb{3.4.6.3.12*}}{Creates a regular (star) polygon tiling made of triangles, squares, hexagons, and twelve-pointed stars.}
\item{\verb{3.4.8.3.8*}}{Creates a regular (star) polygon tiling made of triangles, squares, octagons, and eight-pointed stars.}
\item{\verb{3.6*.6**}}{Creates a regular (star) polygon tiling made of triangles and six-pointed stars.}
\item{\verb{4.2*.4.2**}}{Creates a polygon tiling made of squares and rhombi.}
\item{\verb{4.4*.4**}}{Creates a regular (star) polygon tiling made of squares and four-pointed stars.}
\item{\verb{4.6.4*.6}}{Creates a regular (star) polygon tiling made of squares, hexagons, and four-pointed stars.}
\item{\verb{4.6*.4.6*.4.6*}}{Creates a regular (star) polygon tiling made of squares and six-pointed stars.}
\item{\verb{4.8*.4**.8*}}{Creates a polygon tiling of squares and eight-pointed stars.}
\item{\verb{6.6*.6.6*}}{Creates a regular (star) polygon tiling made of hexagons and six-pointed stars.}
\item{\verb{8.4*.8.4*}}{Creates a regular (star) polygon tiling made of octagons and four-pointed stars.}
\item{\verb{9.3.9.3*}}{Creates a regular (star) polygon tiling made of triangles, nonagons, and three-pointed stars.}
\item{\verb{12.3*.12.3*}}{Creates a regular (star) polygon tiling made of dodecagons and three-pointed stars.}
\item{\verb{12.12.4*}}{Creates a regular (star) polygon tiling made of dodecagons and four-pointed stars.}
\item{\verb{18.18.3*}}{Creates a regular (star) polygon tiling made of eighteen-sided polygons and three-pointed stars.}
}
}
\examples{
 print(names_polygon_tiling)
 if (require("grid")) {
   x_hex <- 0.5 + 0.5 * cos(seq(2 * pi / 4, by = 2 * pi / 6, length.out = 6))
   y_hex <- 0.5 + 0.5 * sin(seq(2 * pi / 4, by = 2 * pi / 6, length.out = 6))
   gp1 <- gpar(fill = "yellow", col = "black")
   gp2 <- gpar(fill = c("yellow", "red"), col = "black")
   gp3 <- gpar(fill = c("yellow", "red", "blue"), col = "black")

   grid.pattern_polygon_tiling(x_hex, y_hex, type = "herringbone", gp = gp1)

   grid.newpage()
   grid.pattern_polygon_tiling(x_hex, y_hex, type = "hexagonal",
                               spacing = 0.2, gp = gp3)

   grid.newpage()
   grid.pattern_polygon_tiling(x_hex, y_hex, type = "pythagorean",
                               spacing = 0.2, gp = gp2)

   grid.newpage()
   grid.pattern_polygon_tiling(x_hex, y_hex, type = "snub_trihexagonal",
                               spacing = 0.2, gp = gp3)

   grid.newpage()
   grid.pattern_polygon_tiling(x_hex, y_hex, type = "rhombille",
                               spacing = 0.2, gp = gp3)
 }

}
\seealso{
The tiling vignette \code{vignette("tiling", package = "gridpattern")} for more
information about these tilings as well as more
examples of polygon tiling using the \code{\link[=grid.pattern_regular_polygon]{grid.pattern_regular_polygon()}} function.
}
\keyword{datasets}
