\name{gcBootSpline}
\Rdversion{1.1}
\alias{gcBootSpline}
\title{
Function to generate a bootstrap sample from a dataset of growth data.
}
\description{
Bootstrapping of a growth curve.
}
\usage{
gcBootSpline(time, data, gcID = "undefined",
             control = grofit.control())
}
\arguments{
  \item{time}{
Numeric vector containing the data for x-axes.
}
  \item{data}{
Numeric vector giving the growth values belonging to each element of \code{time}.
}
  \item{gcID}{
Vector (of any length) identifying the growth curve data.
}
  \item{control}{
Object of class \code{grofit.control} containing a list of options generated by the function \link{grofit.control}.
}
}
\details{
A bootstrap sample (with replacement) is generated from the original data. For each of the bootstrap samples, the characteristic parameters \eqn{\lambda}, \eqn{\mu}, \eqn{A} and integral are estimated.
}
\value{
Generates an object of class \code{gcBootSpline}
\item{raw.time}{Raw data given to the function; equivalent to \code{time}.}
\item{raw.data}{Raw data given to the function; equivalent to \code{data}.}
\item{gcID}{Identifier, given to the function as \code{gcID}.}
\item{boot.time}{Table of concentration values per column, resulting from each spline fit of the bootstrap.}
\item{boot.data}{Table of response values per column, resulting from each spline fit of the bootstrap.}
\item{boot.gcSpline}{List containing all \code{gcFitSpline} objects generated by the call of \code{\link{gcFitSpline}}.}
\item{lambda}{Vector containing all the estimates from the bootstrap sample for the lag-phase.}
\item{mu}{Vector containing all the estimates from the bootstrap sample for the maximum slope.}
\item{A}{Vector containing all the estimates from the bootstrap sample for the maximum growth value.}
\item{integral}{Vector containing all the estimates from the bootstrap sample for the integral.}
\item{bootFlag}{Logical, indicating an empty bootstrap sample.}
\item{control}{Object of class \code{grofit.control} containing list of options passed to the function as \code{control}.}
}
\examples{
x <- 1:30
y <- 1/(1+exp(0.5*(15-x)))+rnorm(30)/20
TestRun <- gcBootSpline(x,y,"ID",grofit.control(nboot.gc=50))
print(summary(TestRun))
plot(TestRun)
}
\seealso{
\code{\link{gcFitModel}}, \code{\link{gcFitSpline}}, \code{\link{gcFit}}, \code{\link{summary.gcBootSpline}}, \code{\link{plot.gcBootSpline}}
}
