\name{gcFitModel}
\Rdversion{1.1}
\alias{gcFitModel}
\title{
Function to fit parametric models to growth data.
}
\description{
Performs a parametric fit of certain models. The model with the best AIC is returned.
}
\usage{
gcFitModel(time, data, gcID = "undefined",
           control = grofit.control())
}
\arguments{
  \item{time}{
Numeric vector containing the data for x-axes.
}
  \item{data}{
Numeric vector giving the growth values belonging to each element of \code{time}.
}
  \item{gcID}{
Vector (of any length) identifying the growth curve data.
}
  \item{control}{
Object of class \code{grofit.control} containing a list of options generated by the function \link{grofit.control}.
}
}
\details{
The function calls \code{\link{gcFitSpline}} that uses the R internal function \code{\link{lowess}} to estimate initial values for the parametric fit. Four different models were tested by default. By means of an AIC criterion it is decided which model fits the data best. The tested models are: Gompertz law, modified Gompertz law, logistic law and Richards law.

Note: If a certain model depicts not an appropriate description of a given data set \code{\link{nls}} might stop and produce an error. This error stems from the generation of infinite or missing values or singular gradients in the optimization algorithm. These errors are not to be taken critical and indicates only that a certain model is not an appropriate description of a certain growth curve. When trying a couple of models it is usual that some of them can not be fitted. To prevent an overflow of almost redundant error messages ("\code{nls(formulamodel, start = init.model) : singular gradient}", "\code{Error in numericDeriv(form[[3L]], names(ind), env) : missing value or an inifinite produced by the model}") they are displayed only as short error message on screen.
If errors were frequently produced in models the user expects to be suitable, a change of the inital value definition (see e.g. \code{\link{initgompertz}}, \code{\link{initlogistic}}) might help.
}
\value{
Generates an object of class \code{gcFitModel}
\item{raw.time}{Raw data given to the function; equivalent to \code{time}.}
\item{raw.data}{Raw data given to the function; equivalent to \code{data}.}
\item{gcID}{Identifier, given to the function as \code{gcID}.}
\item{fit.time}{Vector of fitted concentration values.}
\item{fit.data}{Vector of fitted growth values.}
\item{parameters}{List of estimated growth values.}
\item{A}{Maximum growth value.}
\item{mu}{Maximum slope.}
\item{lambda}{Lag-phase.}
\item{integral}{Integral under growth curve.}
\item{model}{String naming the parametric model used.}
\item{nls}{\code{nls} object generated by the R internal function \code{\link{nls}}.}
\item{reliable}{Logical, indicating wether the provided data is reliable (to be set manually).}
\item{fitFlag}{Logical, indicating wether a model could fitted successfully to data.}
\item{control}{Object of class \code{grofit.control} containing list of options passed to the function as \code{control}.}
}
\examples{
x <- 1:30
y <- 1/(1+exp(0.5*(15-x)))+rnorm(30)/20
TestRun <- gcFitModel(x,y)
print(summary(TestRun))
plot(TestRun)
}
\seealso{
\code{\link{gompertz}}, \code{\link{gompertz.exp}}, \code{\link{richards}}, \code{\link{logistic}}, \code{\link{gcFitSpline}}, \code{\link{summary.gcFitModel}}, \code{\link{plot.gcFitModel}}
}
