% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.x.s.R
\name{make.x.s}
\alias{make.x.s}
\title{Forms component group ID vector of X}
\usage{
make.x.s(df, num.groups, groups)
}
\arguments{
\item{df}{A dataframe containing named component variables}

\item{num.groups}{An integer representing the number of component groups desired}

\item{groups}{A list, each item in the list being a string vector of variable names for one component group}
}
\value{
A vector of integers, each integer relating how many columns are in each group
}
\description{
This function returns a vector which lets WQS.fit know the size and order of groups in X
}
\examples{
data("WQSdata")
group_list <- list(c("X1", "X2", "X3"), c("X4", "X7"), c("X5", "X6", "X9", "X8"))
x.s <- make.x.s(WQSdata, 3, group_list)
x.s
}
