% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rearrange.R
\name{rearrange}
\alias{rearrange}
\title{Rearrange data by a set of methods.}
\usage{
rearrange(
  data,
  method = "pair_extremes",
  unequal_method = "middle",
  drop_rearrange_factor = TRUE,
  rearrange_factor_name = ".rearrange_factor"
)
}
\arguments{
\item{data}{Data frame or Vector.}

\item{method}{Name of method used to create rearrange factor.
Currently only \code{pair_extremes}.
\subsection{pair_extremes}{
The first and last rows are grouped. The second and the second last rows are grouped. Etc.

E.g.: 1,2,3,2,1
}}

\item{unequal_method}{Name of method to use for dealing with unequal number of rows/elements in data.
\code{first}, \code{middle} or \code{last}
\subsection{first}{
The first group will have size 1.

E.g. \strong{1},2,3,4,4,3,2.
}
\subsection{middle}{
The middle group will have size 1.

E.g. 1,2,4,5,\strong{3},5,4,2,1.
}
\subsection{last}{
The last group will have size 1.

E.g. 1,2,3,4,4,3,2,1,\strong{5}.
}}

\item{drop_rearrange_factor}{Whether to drop rearrange factor after sorting dataset. \code{Logical}.}

\item{rearrange_factor_name}{Name of rearrange factor.

N.B. Only used when \code{drop_rearrange_factor} is FALSE.}
}
\description{
\strong{Internal}: Creates a rearrange factor and sorts the data by it.
A rearrange factor is simply a vector of integers to sort by.
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\keyword{internal}
