% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouped_robustslr.R
\name{grouped_robustslr}
\alias{grouped_robustslr}
\title{Function to run robust simple linear regression (slr) on multiple variables across
multiple grouping variables.}
\usage{
grouped_robustslr(
  data,
  dep.vars,
  indep.vars,
  grouping.vars,
  nrep = 1000,
  control = robust::lmRob.control(tlo = 1e-04, tua = 1.5e-06, tl = 1e-06, estim =
    "Final", initial.alg = "Auto", final.alg = "MM")
)
}
\arguments{
\item{data}{Dataframe from which variables are to be taken.}

\item{dep.vars}{List criterion or dependent variables for regression (\code{y} in
\code{y ~ x}).}

\item{indep.vars}{List predictor or independent variables for regression (\code{x}
in \code{y ~ x}).}

\item{grouping.vars}{List of grouping variables.}

\item{nrep}{the number of random subsamples to be drawn. If \code{"Exhaustive"} resampling is being used, the value of \code{nrep} is ignored.}

\item{control}{a list of control parameters to be used in the numerical algorithms. See \code{\link[robust]{lmRob.control}} for the possible control parameters and their default settings.}
}
\value{
A tibble dataframe with tidy results from robust linear regression
analyses. The estimates are standardized, i.e. the \code{lm} model used is
\code{scale(y) ~ scale(x)}, and not \code{y ~ x}.
}
\description{
Function to run robust simple linear regression (slr) on multiple variables across
multiple grouping variables.
}
\examples{
# for reproducibility
set.seed(123)

# in case of just one grouping variable
groupedstats::grouped_robustslr(
  data = iris,
  dep.vars = c(Sepal.Length, Petal.Length),
  indep.vars = c(Sepal.Width, Petal.Width),
  grouping.vars = Species
)
}
\author{
Indrajeet Patil
}
