% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{gcvals}
\alias{gcvals}
\title{Creates an object of type gcvals.}
\usage{
gcvals(k, k_se, k_p, n0, n0_se, n0_p, r, r_se, r_p, sigma, df, t_mid, dt, auc_l,
  auc_e, note)
}
\arguments{
\item{k}{The carrying capacity parameter}

\item{k_se}{The standard error of the carrying capacity parameter}

\item{k_p}{The p value of the carrying capacity parameter}

\item{n0}{The initial population size}

\item{n0_se}{The standard error of the initial population size}

\item{n0_p}{The p value of the initial population size}

\item{r}{The growth rate}

\item{r_se}{The standard error of the growth rate}

\item{r_p}{The p value of the growthrate}

\item{sigma}{Residual standard error from non-linear least squares fit
of the model to the data}

\item{df}{Degrees of freedom}

\item{t_mid}{The time at the inflection point of the logistic curve
(occurs at half of the carrying capacity)}

\item{dt}{The maximum doubling time, obtained by evaluating the
the unrestrained growth of the population with growth rate r}

\item{auc_l}{The area under the curve of the fitted logistic equation
from time 0 to time t}

\item{auc_e}{The area under the curve of the measurements.}

\item{note}{Feedback on common problems with fitting the logistic curve
to the data}
}
\value{
An object of class gcvals.
}
\description{
Constructor function for the "gcvals" class. This object is most often
obtained when calling  \code{\link{SummarizeGrowth}} (it is the first
parameter in the \code{\link{gcvals}} object).
}
