% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bactgrowth.R
\docType{data}
\name{bactgrowth}
\alias{bactgrowth}
\title{Plate Reader Data of Bacterial Growth}
\format{
Data frame with the following columns:
\describe{
  \item{strain}{identifier of the bacterial strain, D=donor, R=recipient, T=transconjugant.}
  \item{replicate}{replicate of the trial.}
  \item{conc}{concentration of the antibiotics (Tetracycline).}
  \item{time}{time in hours.}
  \item{value}{bacteria concentration measured as optical density.}
}
}
\source{
Claudia Seiler, TU Dresden, Institute of Hydrobiology.
}
\description{
Example data set from growth experiments with different
concentrations of antibiotics.
}
\details{
This rather 'difficult' data set was intentionally selected to make model
fitting by the package more challenging.
}
\examples{
## plot data and determine growth rates
data(bactgrowth)


library(lattice)
xyplot(value ~ time | strain + as.factor(conc),
      data = bactgrowth, groups = replicate)
}
\keyword{data}
