% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design_cont.R
\name{design_cont}
\alias{design_cont}
\title{Design the clinical trial for continuous outcome}
\usage{
design_cont(delta0, delta1, alpha, beta, K, frac)
}
\arguments{
\item{delta0}{Standardized effect size in ineffective arm.}

\item{delta1}{Standardized effect size in effective arm.}

\item{alpha}{Type I error.}

\item{beta}{Type II error.}

\item{K}{Number of treatment arms.}

\item{frac}{Vector of fractions for information time at each look.}
}
\value{
List of cumulative sample size for each stage of treatment and control groups along with maximum total sample size of the trial. It also provides efficacy and futility boundaries of the trial.
}
\description{
This function generates the design parameters of a clinical trial for continuous outcome.
}
\examples{
design_cont(delta0=0.178,delta1=0.545,alpha = 0.05, beta = 0.1, K = 4,frac=c(1/2,1))
}
