% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grpdelay.R
\name{grpdelay}
\alias{grpdelay}
\alias{print.grpdelay}
\alias{plot.grpdelay}
\alias{grpdelay.default}
\alias{grpdelay.Arma}
\alias{grpdelay.Ma}
\alias{grpdelay.Sos}
\alias{grpdelay.Zpg}
\title{Group delay}
\usage{
grpdelay(filt, ...)

\method{print}{grpdelay}(x, ...)

\method{plot}{grpdelay}(
  x,
  xlab = if (x$HzFlag) "Frequency (Hz)" else "Frequency (rad/sample)",
  ylab = "Group delay (samples)",
  type = "l",
  ...
)

\method{grpdelay}{default}(filt, a = 1, n = 512, whole = FALSE, fs = NULL, ...)

\method{grpdelay}{Arma}(filt, ...)

\method{grpdelay}{Ma}(filt, ...)

\method{grpdelay}{Sos}(filt, ...)

\method{grpdelay}{Zpg}(filt, ...)
}
\arguments{
\item{filt}{for the default case, the moving-average coefficients of an ARMA
model or filter. Generically, filt specifies an arbitrary model or filter
operation.}

\item{...}{for methods of grpdelay, arguments are passed to the default
method. For plot.grpdelay, additional arguments are passed through to plot.}

\item{x}{object to be plotted.}

\item{xlab, ylab, type}{as in plot, but with more sensible defaults.}

\item{a}{the autoregressive (recursive) coefficients of an ARMA filter.}

\item{n}{number of points at which to evaluate the frequency response. If
\code{n} is a vector with a length greater than 1, then evaluate the
frequency response at these points. For fastest computation, \code{n}
should factor into a small number of small primes. Default: 512.}

\item{whole}{FALSE (the default) to evaluate around the upper half of the
unit circle or TRUE to evaluate around the entire unit circle.}

\item{fs}{sampling frequency in Hz. If not specified, the frequencies are in
radians.}
}
\value{
A list of class \code{grpdelay} with items:
\describe{
  \item{gd}{the group delay, in units of samples. It can be converted to
  seconds by multiplying by the sampling period (or dividing by the sampling
  rate fs).}
  \item{w}{frequencies at which the group delay was calculated.}
  \item{ns}{number of points at which the group delay was calculated.}
  \item{Hzflag}{TRUE for frequencies in Hz, FALSE for frequencies in
  radians.}

}
}
\description{
Compute the average delay of a filter (group delay).
}
\details{
If the denominator of the computation becomes too small, the group delay is
set to zero. (The group delay approaches infinity when there are poles or
zeros very close to the unit circle in the z plane.)
}
\examples{
# Two Zeros and Two Poles
b <- poly(c(1 / 0.9 * exp(1i * pi * 0.2), 0.9 * exp(1i * pi * 0.6)))
a <- poly(c(0.9 * exp(-1i * pi * 0.6), 1 / 0.9 * exp(-1i * pi * 0.2)))
gpd <- grpdelay(b, a, 512, whole = TRUE, fs = 1)
print(gpd)
plot(gpd)

}
\references{
\url{https://ccrma.stanford.edu/~jos/filters/Numerical_Computation_Group_Delay.html}\cr
\url{https://en.wikipedia.org/wiki/Group_delay}
}
\author{
Paul Kienzle, \email{pkienzle@users.sf.net},\cr
 Julius O. Smith III, \email{jos@ccrma.stanford.edu}.\cr
 Conversion to R by Tom Short,\cr
 adapted by Geert van Boxtel, \email{gjmvanboxtel@gmail.com}
}
