% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hamming.R
\name{hamming}
\alias{hamming}
\title{Hamming window}
\usage{
hamming(n, method = c("symmetric", "periodic"))
}
\arguments{
\item{n}{Window length, specified as a positive integer.}

\item{method}{Character string. Window sampling method, specified as:
\describe{
  \item{"symmetric"}{(Default). Use this option when using windows for filter
  design.}
  \item{"periodic"}{This option is useful for spectral analysis because it
  enables a windowed signal to have the perfect periodic extension implicit
  in the discrete Fourier transform. When \code{"periodic"} is specified, the
  function computes a window of length \code{n + 1} and returns the first
  \code{n} points.}
}}
}
\value{
Hamming window, returned as a vector. If you specify a one-point
  window \code{(n = 1)}, the value 1 is returned.
}
\description{
Return the filter coefficients of a Hamming window of length \code{n}.
}
\details{
The Hamming window is a member of the family of cosine sum windows.
}
\examples{

h <- hamming(64)
plot (h, type = "l", xlab = "Samples", ylab =" Amplitude")

hs = hamming(64,'symmetric')
hp = hamming(63,'periodic')
plot (hs, type = "l", xlab = "Samples", ylab =" Amplitude")
lines(hp, col="red")

}
\author{
Andreas Weingessel, \email{Andreas.Weingessel@ci.tuwien.ac.at}.\cr
Conversion to R by Geert van Boxtel \email{G.J.M.vanBoxtel@gmail.com}.
}
