% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cheb2ap.R
\name{cheb2ap}
\alias{cheb2ap}
\title{Chebyshev Type II filter prototype}
\usage{
cheb2ap(n, Rs)
}
\arguments{
\item{n}{Order of the filter.}

\item{Rs}{dB of stop-band ripple.}
}
\value{
list of class \code{\link{Zpg}} containing poles and gain of the
  filter
}
\description{
Return the poles and gain of an analog Chebyshev Type II lowpass filter
prototype.
}
\details{
This function exists for compatibility with 'Matlab' and 'Octave' only, and
is equivalent to \code{cheby2(n, Rp, 1, "low", "s")}.
}
\examples{
## 9th order Chebyshev type II low-pass analog filter
zp <- cheb2ap(9, 30)
w <- seq(0, 4, length.out = 128)
freqs(zp, w)

}
\author{
Carne Draug, \email{carandraug+dev@gmail.com}.\cr
 Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
