% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sawtooth.R
\name{sawtooth}
\alias{sawtooth}
\title{Sawtooth or triangle wave}
\usage{
sawtooth(t, width = 1)
}
\arguments{
\item{t}{Sample times of unit sawtooth wave specified by a vector.}

\item{width}{Real number between 0 and 1 which specifies the point between 0
and \eqn{2 \pi} where the maximum is. The function increases linearly from
-1 to 1 in the interval from 0 to \eqn{ 2 * \pi * width}, and decreases
linearly from 1 to -1 in the interval from \eqn{2 * \pi * width} to \eqn{2
* \pi}. Default: 1 (standard sawtooth).}
}
\value{
Sawtooth wave, returned as a vector.
}
\description{
Returns samples of the sawtooth function at the times indicated by \code{t}.
}
\details{
The code \code{y <- sawtooth(t)} generates a sawtooth wave with period
\eqn{2\pi} for the elements of the time array \code{t}. \code{sawtooth()} is
similar to the sine function but creates a sawtooth wave with peaks of –1 and
1. The sawtooth wave is defined to be –1 at multiples of \eqn{2\pi} and to
increase linearly with time with a slope of \eqn{1/\pi} at all other times.

\code{y <- sawtooth(t, width)} generates a modified triangle wave with the
maximum location at each period controlled by \code{width}. Set \code{width}
to 0.5 to generate a standard triangle wave.
}
\examples{

T <- 10 * (1 / 50)
fs <- 1000
t <- seq(0, T-1/fs, 1/fs)
y <- sawtooth(2 * pi * 50 *t)
plot(t, y, type="l", xlab = "", ylab = "", main = "50 Hz sawtooth wave")

T <- 10 * (1 / 50)
fs <- 1000
t <- seq(0, T-1/fs, 1/fs)
y <- sawtooth(2 * pi * 50 * t, 1/2)
plot(t, y, type="l", xlab = "", ylab = "", main = "50 Hz triangle wave")

}
\author{
Juan Aguado.\cr
Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
