% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nls-methods.R
\name{df.residual.gsl_nls}
\alias{df.residual.gsl_nls}
\title{Residual degrees-of-freedom}
\usage{
\method{df.residual}{gsl_nls}(object, ...)
}
\arguments{
\item{object}{An object inheriting from class \code{"gsl_nls"}.}

\item{...}{At present no optional arguments are used.}
}
\value{
Integer residual degrees-of-freedom similar to \code{\link[stats]{df.residual}}.
}
\description{
Returns the residual degrees-of-freedom from a fitted \code{"gsl_nls"} object.
}
\examples{
## data
set.seed(1)
x <- 1:10
y <- 1 + 0.5 * (1:10) + rnorm(10, sd = 0.1)
## model
obj <- gsl_nls(fn = y ~ a + b * x, data = data.frame(x = x, y = y), start = c(a = 0, b = 1))
df.residual(obj)
}
\seealso{
\code{\link[stats]{df.residual}}
}
