% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_mix.R
\name{pca_mix}
\alias{pca_mix}
\title{PCA of a mixture of numerical and categorical data}
\usage{
pca_mix(X_tr, X_va, npcs = 1)
}
\arguments{
\item{X_tr}{data.frame of training data}

\item{X_va}{data.frame of validation data}

\item{npcs}{number of principal components to keep}
}
\value{
a list of training and validation PC scores
}
\description{
Wrapper for the \code{PCAmixdata::PCAmix()} function to be used in the main cross-validation procedure.
}
\examples{
# Example inputs
data(wine, package = "FactoMineR")
X <- wine[, c(1, 2, 16, 22)]
X$Label <- factor(X$Label)
X$Soil <- factor(X$Soil)
X_tr <- X[1:15, ]
X_va <- X[16:21, ]
npcs <- 2

# Example use
pca_mix(
    X_tr = X[1:15, ],
    X_va = X[16:21, ],
    npcs = 2
)
}
\references{
Chavent M, Kuentz V, Labenne A, Liquet B, Saracco J (2017). PCAmixdata: Multivariate Analysis of Mixed Data. R package version 3.1, \url{https://CRAN.R-project.org/package=PCAmixdata}.
}
\author{
Edoardo Costantini, 2023
}
