% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp_LRT.R
\name{cp_LRT}
\alias{cp_LRT}
\title{Compute likelihood ratio test}
\usage{
cp_LRT(ll_restricted, ll_full)
}
\arguments{
\item{ll_restricted}{numeric vector of length 1 (or an object of class 'logLik') storing the log-likelihood of the observed data under the restricted model}

\item{ll_full}{numeric vector of length 1 (or an object of class 'logLik') storing the log-likelihood of the observed data under the full model}
}
\value{
numeric vector of length 1 storing the likelihood ratio test statistic
}
\description{
Computes the likelihood ratio expressed as a difference between the log-likelihoods of observed data under two nested competing models.
}
\details{
Note that:
\itemize{
\item The full model is always the model with more estimated parameters, the model with more predictor variables.
\item The restricted model is the model with fewer estimated parameters.
\item The restricted model must be nested within the full model.
}
}
\examples{
# Fit a nested model
nested <- glm(mpg ~ cyl + disp, data = mtcars)

# Fit a complex model
complex <- glm(mpg ~ cyl + disp + hp + am, data = mtcars)

# Compute log-likelihood statistic with your function
LRT_M <- cp_LRT(
    ll_restricted = logLik(nested),
    ll_full = logLik(complex)
)
}
\author{
Edoardo Costantini, 2023
}
