% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp_thrs_PR2.R
\name{cp_thrs_PR2}
\alias{cp_thrs_PR2}
\title{Compute threshold values based on the pseudo R2}
\usage{
cp_thrs_PR2(dv, ivs, fam)
}
\arguments{
\item{dv}{numeric vector or factor of dependent variable values}

\item{ivs}{\eqn{n \times p} data.frame of independent variables (factors allowed)}

\item{fam}{character vector of length 1 storing the description of the error distribution and link function to be used in the model (see \code{\link[=cv_gspcr]{cv_gspcr()}} for the list of possible options)}
}
\value{
A vector of bivariate association measures between \code{dv} and \code{ivs}.
}
\description{
Produces a vector of threshold values that define active predictors.
}
\examples{
# Example inputs
dv <- mtcars[, 1]
ivs <- mtcars[, -1]

# Use the function
cp_thrs_PR2(dv, ivs, fam = "gaussian")

}
\author{
Edoardo Costantini, 2023
}
