% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{intens_theta}
\alias{intens_theta}
\title{Preprocess raw values and calculate Intensity and Theta values}
\usage{
intens_theta(raw, norm = "quantile", scaling = "mean", transf = "log",
  pn = 2)
}
\arguments{
\item{raw}{Raw_data object.}

\item{norm}{Method for the normalization. Currently only quantile normalization is implemented.}

\item{scaling}{Logical, if each SNP should be scaled or not.}

\item{transf}{Method for transformation of the raw values.
"none", "log" and "fourth-root" are implemented.}

\item{pn}{Numeric, p-norm for the intensity calculation.}
}
\value{
List with two matrices "intensity" (signal intensities) and "theta" (genotype value).
}
\description{
Preprocess raw values and calculate Intensity and Theta values
}
\examples{
if(require(brassicaData)){
data("raw_napus", package = "brassicaData")
\dontshow{
raw_napus <- filt_samp(raw_napus, raw_napus$samples[-(1:10)])
raw_napus <- filt_snps(raw_napus, raw_napus$snps[-(1:10)])
}
dat <- intens_theta(raw_napus)
}
}

