% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_sigma3}
\alias{gsw_sigma3}
\title{Potential density anomaly referenced to 3000 dbar}
\usage{
gsw_sigma3(SA, CT)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ deg C ]}
}
\value{
potential density anomaly with reference pressure 3000 dbar [ kg/m^3 ]
}
\description{
This uses the 48-term density equation, and returns
potential density referenced to a pressure of 3000 dbar,
minus 1000 kg/m^3.
}
\examples{
gsw_sigma3(34.7118, 28.8099) # 34.002600253012133
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_sigma3.html}
}
\seealso{
Use \code{\link{gsw_sigma0}} for 0 dbar pressure, \code{\link{gsw_sigma1}} for 1000 dbar, \code{\link{gsw_sigma2}} for 2000 dbar, or \code{\link{gsw_sigma4}} for 4000 dbar.
}

