% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_CT_from_rho}
\alias{gsw_CT_from_rho}
\title{Conservative Temperature from Density, Absolute Salinity and Pressure}
\usage{
gsw_CT_from_rho(rho, SA, p)
}
\arguments{
\item{rho}{seawater density [ kg/m^3 ]}

\item{SA}{Absolute Salinity [ g/kg ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}
}
\value{
A list containing two estimates of Conservative Temperature:
\code{CT} and \code{CT_multiple}, each in [ degC ].
}
\description{
Conservative Temperature from Density, Absolute Salinity and Pressure
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05 dated 2017-07-27, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '13ab33cea0e9059d3b3f3dfef78e9591c94af9f8'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
rho <- c(1021.8484, 1022.2647, 1024.4207, 1027.7841, 1029.8287, 1031.9916)
SA <- c(   34.7118,   34.8915,   35.0256,   34.8472,   34.7366,   34.7324)
p <- c(         10,        50,       125,       250,       600,      1000)
r <- gsw_CT_from_rho(rho, SA, p)
expect_equal(r$CT, c(28.784377302226968, 28.432402127485858, 22.808745445250068,
                   10.260169334807866, 6.887336649146716, 4.404594162282834))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_CT_from_rho.html}
}
\seealso{
Other things related to density: \code{\link{gsw_CT_maxdensity}},
  \code{\link{gsw_SA_from_rho}},
  \code{\link{gsw_alpha_on_beta}},
  \code{\link{gsw_alpha_wrt_t_exact}},
  \code{\link{gsw_alpha_wrt_t_ice}},
  \code{\link{gsw_alpha}},
  \code{\link{gsw_beta_const_t_exact}},
  \code{\link{gsw_beta}},
  \code{\link{gsw_pot_rho_t_exact}},
  \code{\link{gsw_rho_alpha_beta}},
  \code{\link{gsw_rho_first_derivatives_wrt_enthalpy}},
  \code{\link{gsw_rho_first_derivatives}},
  \code{\link{gsw_rho_ice}}, \code{\link{gsw_rho_t_exact}},
  \code{\link{gsw_rho}}, \code{\link{gsw_sigma0}},
  \code{\link{gsw_sigma1}}, \code{\link{gsw_sigma2}},
  \code{\link{gsw_sigma3}}, \code{\link{gsw_sigma4}},
  \code{\link{gsw_specvol_alpha_beta}},
  \code{\link{gsw_specvol_anom_standard}},
  \code{\link{gsw_specvol_ice}},
  \code{\link{gsw_specvol_t_exact}},
  \code{\link{gsw_specvol}}
}
