% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_pot_enthalpy_ice_freezing_first_derivatives}
\alias{gsw_pot_enthalpy_ice_freezing_first_derivatives}
\title{First Derivatives of Potential Enthalpy}
\usage{
gsw_pot_enthalpy_ice_freezing_first_derivatives(SA, p)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}
}
\value{
A list containing \code{pot_enthalpy_ice_freezing_SA} [ (J/kg)/(g/kg) ], the derivative of
potential enthalpy with respect to Absolute Salinity,
and \code{pot_enthalpy_ice_freezing_p} [ unitless ], the derivative of
Conservative Temperature with respect to potential temperature. (Note that the second
quantity is denoted \code{pot_enthalpy_ice_freezing_P} in the documentation for the Matlab function.)
}
\description{
First Derivatives of Potential Enthalpy
}
\section{Implementation Note}{


This R function uses a wrapper to a C function contained within the GSW-C
system as updated 2021-12-28 at \url{https://github.com/TEOS-10/GSW-C} with
git commit `98f0fd40dd9ceb0ba82c9d47ac750e935a7d0459`.

The C function uses data from the \code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version of the mat file is no longer displayed on the
TEOS-10.org website.  Therefore, in the interests of making GSW-R be
self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip} on 2022-05-25,
the .mat file was stored in the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset used in GSW-R
was created based on that .mat file.

Please consult \url{http://www.teos-10.org} to learn more about the various
TEOS-10 software systems.
}

\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
p <- c(      10,      50,     125,     250,     600,    1000)
r <- gsw_pot_enthalpy_ice_freezing_first_derivatives(SA, p)
stopifnot(all.equal(r$pot_enthalpy_ice_freezing_SA/1e2,
      c(-1.183484968590718, -1.184125268891200, -1.184619267864844,
      -1.184026131143674, -1.183727706650925, -1.183814873741961)))
stopifnot(all.equal(r$pot_enthalpy_ice_freezing_p/1e-3,
      c(-0.202880939983260, -0.203087335312542, -0.203473018454630,
      -0.204112435106666, -0.205889571619502, -0.207895691215823)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_pot_enthalpy_ice_freezing_first_derivatives.html}
}
