% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_create_modify.R
\name{tab_header}
\alias{tab_header}
\title{Add a table header}
\usage{
tab_header(data, title, subtitle = NULL)
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{title, subtitle}{Text to be used in the table title and, optionally, for
the table subtitle. We can elect to use the \code{\link[=md]{md()}} and \code{\link[=html]{html()}} helper
functions to style the text as Markdown or to retain HTML elements in the
text.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
We can add a table header to the \strong{gt} table with a title and even a
subtitle. A table header is an optional table part that is positioned above
the column labels. We have the flexibility to use Markdown formatting for the
header's title and subtitle. Furthermore, if the table is intended for HTML
output, we can use HTML in either of the title or subtitle.
}
\section{Figures}{

\if{html}{\figure{man_tab_header_1.png}{options: width=100\%}}
}

\section{Function ID}{

2-1
}

\examples{
# Use `gtcars` to create a gt table;
# add a header part to contain a title
# and subtitle
tab_1 <-
  gtcars \%>\%
  dplyr::select(mfr, model, msrp) \%>\%
  dplyr::slice(1:5) \%>\%
  gt() \%>\%
  tab_header(
    title = md("Data listing from **gtcars**"),
    subtitle = md("`gtcars` is an R dataset")
  )

}
\seealso{
Other Create or Modify Parts: 
\code{\link{tab_footnote}()},
\code{\link{tab_options}()},
\code{\link{tab_row_group}()},
\code{\link{tab_source_note}()},
\code{\link{tab_spanner_delim}()},
\code{\link{tab_spanner}()},
\code{\link{tab_stubhead}()},
\code{\link{tab_style}()}
}
\concept{Create or Modify Parts}
