% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_create_modify.R
\name{tab_style}
\alias{tab_style}
\title{Add custom styles to one or more cells}
\usage{
tab_style(data, style, locations)
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{style}{a vector of styles to use. The \code{\link[=cell_text]{cell_text()}}, \code{\link[=cell_fill]{cell_fill()}}, and
\code{\link[=cell_borders]{cell_borders()}} helper functions can be used here to more easily generate
valid styles.  If using more than one helper function to define styles, all
calls must be enclosed in a \code{\link[=list]{list()}}. Custom CSS declarations can be used
for HTML output by including a \code{\link[=css]{css()}}-based statement as a list item.}

\item{locations}{the cell or set of cells to be associated with the style.
Supplying any of the \verb{cells_*()} helper functions is a useful way to target
the location cells that are associated with the styling. These helper
functions are: \code{\link[=cells_title]{cells_title()}}, \code{\link[=cells_stubhead]{cells_stubhead()}},
\code{\link[=cells_column_spanners]{cells_column_spanners()}}, \code{\link[=cells_column_labels]{cells_column_labels()}}, \code{\link[=cells_row_groups]{cells_row_groups()}},
\code{\link[=cells_stub]{cells_stub()}}, \code{\link[=cells_body]{cells_body()}}, \code{\link[=cells_summary]{cells_summary()}}, \code{\link[=cells_grand_summary]{cells_grand_summary()}},
\code{\link[=cells_stub_summary]{cells_stub_summary()}}, \code{\link[=cells_stub_grand_summary]{cells_stub_grand_summary()}}, \code{\link[=cells_footnotes]{cells_footnotes()}},
and \code{\link[=cells_source_notes]{cells_source_notes()}}. Additionally, we can enclose several
\verb{cells_*()} calls within a \code{list()} if we wish to apply styling to
different types of locations (e.g., body cells, row group labels, the table
title, etc.).}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
With the \code{tab_style()} function we can target specific cells and apply styles
to them. This is best done in conjunction with the helper functions
\code{\link[=cell_text]{cell_text()}}, \code{\link[=cell_fill]{cell_fill()}}, and \code{\link[=cell_borders]{cell_borders()}}. At present this function
is focused on the application of styles for HTML output only (as such, other
output formats will ignore all \code{tab_style()} calls). Using the aforementioned
helper functions, here are some of the styles we can apply:
\itemize{
\item the background color of the cell (\code{\link[=cell_fill]{cell_fill()}}: \code{color})
\item the cell's text color, font, and size (\code{\link[=cell_text]{cell_text()}}: \code{color}, \code{font},
\code{size})
\item the text style (\code{\link[=cell_text]{cell_text()}}: \code{style}), enabling the use of italics or
oblique text.
\item the text weight (\code{\link[=cell_text]{cell_text()}}: \code{weight}), allowing the use of thin to
bold text (the degree of choice is greater with variable fonts)
\item the alignment and indentation of text (\code{\link[=cell_text]{cell_text()}}: \code{align} and
\code{indent})
\item the cell borders (\code{\link[=cell_borders]{cell_borders()}})
}
}
\section{Figures}{

\if{html}{\figure{man_tab_style_1.png}{options: width=100\%}}

\if{html}{\figure{man_tab_style_2.png}{options: width=100\%}}

\if{html}{\figure{man_tab_style_3.png}{options: width=100\%}}
}

\section{Function ID}{

2-8
}

\examples{
# Use `exibble` to create a gt table;
# add styles that are to be applied
# to data cells that satisfy a
# condition (using `tab_style()`)
tab_1 <-
  exibble \%>\%
  dplyr::select(num, currency) \%>\%
  gt() \%>\%
  fmt_number(
    columns = c(num, currency),
    decimals = 1
  ) \%>\%
  tab_style(
    style = list(
      cell_fill(color = "lightcyan"),
      cell_text(weight = "bold")
      ),
    locations = cells_body(
      columns = num,
      rows = num >= 5000
    )
  ) \%>\%
  tab_style(
    style = list(
      cell_fill(color = "#F9E3D6"),
      cell_text(style = "italic")
      ),
    locations = cells_body(
      columns = currency,
      rows = currency < 100
    )
  )

# Use `sp500` to create a gt table;
# color entire rows of cells based
# on values in a particular column
tab_2 <-
  sp500 \%>\%
  dplyr::filter(
    date >= "2015-12-01" &
    date <= "2015-12-15"
  ) \%>\%
  dplyr::select(-c(adj_close, volume)) \%>\%
  gt() \%>\%
  tab_style(
    style = cell_fill(color = "lightgreen"),
    locations = cells_body(
      rows = close > open)
  ) \%>\%
  tab_style(
    style = list(
      cell_fill(color = "red"),
      cell_text(color = "white")
      ),
    locations = cells_body(
      rows = open > close)
  )

# Use `exibble` to create a gt table;
# replace missing values with the
# `fmt_missing()` function and then
# add styling to the `char` column
# with `cell_fill()` and with a
# CSS style declaration
tab_3 <-
  exibble \%>\%
  dplyr::select(char, fctr) \%>\%
  gt() \%>\%
  fmt_missing(everything()) \%>\%
  tab_style(
    style = list(
      cell_fill(color = "lightcyan"),
      "font-variant: small-caps;"
    ),
    locations = cells_body(columns = char)
  )

}
\seealso{
\code{\link[=cell_text]{cell_text()}}, \code{\link[=cell_fill]{cell_fill()}}, and \code{\link[=cell_borders]{cell_borders()}} as helpers for
defining custom styles and \code{\link[=cells_body]{cells_body()}} as one of many useful helper
functions for targeting the locations to be styled.

Other Create or Modify Parts: 
\code{\link{tab_footnote}()},
\code{\link{tab_header}()},
\code{\link{tab_options}()},
\code{\link{tab_row_group}()},
\code{\link{tab_source_note}()},
\code{\link{tab_spanner_delim}()},
\code{\link{tab_spanner}()},
\code{\link{tab_stubhead}()}
}
\concept{Create or Modify Parts}
