% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{extract_summary}
\alias{extract_summary}
\title{Extract a summary list from a \strong{gt} object}
\usage{
extract_summary(data)
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}
}
\value{
A list of data frames containing summary data.
}
\description{
Get a list of summary row data frames from a \code{gt_tbl} object where summary
rows were added via the \code{\link[=summary_rows]{summary_rows()}} function. The output data frames
contain the \code{group_id} and \code{rowname} columns, whereby \code{rowname} contains
descriptive stub labels for the summary rows.
}
\section{Figures}{

\if{html}{\figure{man_extract_summary_1.png}{options: width=100\%}}
}

\section{Function ID}{

13-5
}

\examples{
# Use `sp500` to create a gt table with
# row groups; create summary rows by row
# group (`min`, `max`, `avg`) and then
# extract the summary rows as a list
# object
summary_extracted <-
  sp500 \%>\%
  dplyr::filter(
    date >= "2015-01-05" &
      date <="2015-01-30"
  ) \%>\%
  dplyr::arrange(date) \%>\%
  dplyr::mutate(
    week = paste0(
      "W", strftime(date, format = "\%V"))
  ) \%>\%
  dplyr::select(-adj_close, -volume) \%>\%
  gt(
    rowname_col = "date",
    groupname_col = "week"
  ) \%>\%
  summary_rows(
    groups = TRUE,
    columns = c(open, high, low, close),
    fns = list(
      min = ~min(.),
      max = ~max(.),
      avg = ~mean(.)),
    formatter = fmt_number,
    use_seps = FALSE
  ) \%>\%
  extract_summary()

# Use the summary list to make a new
# gt table; the key thing is to use
# `dplyr::bind_rows()` and then pass the
# tibble to `gt()`
tab_1 <-
  summary_extracted \%>\%
  unlist(recursive = FALSE) \%>\%
  dplyr::bind_rows() \%>\%
  gt(groupname_col = "group_id")

}
\seealso{
Other Export Functions: 
\code{\link{as_latex}()},
\code{\link{as_raw_html}()},
\code{\link{as_rtf}()},
\code{\link{gtsave}()}
}
\concept{Export Functions}
