% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_create_modify.R
\name{tab_options}
\alias{tab_options}
\title{Modify the table output options}
\usage{
tab_options(
  data,
  container.width = NULL,
  container.height = NULL,
  container.overflow.x = NULL,
  container.overflow.y = NULL,
  table.width = NULL,
  table.layout = NULL,
  table.align = NULL,
  table.margin.left = NULL,
  table.margin.right = NULL,
  table.background.color = NULL,
  table.additional_css = NULL,
  table.font.names = NULL,
  table.font.size = NULL,
  table.font.weight = NULL,
  table.font.style = NULL,
  table.font.color = NULL,
  table.font.color.light = NULL,
  table.border.top.style = NULL,
  table.border.top.width = NULL,
  table.border.top.color = NULL,
  table.border.right.style = NULL,
  table.border.right.width = NULL,
  table.border.right.color = NULL,
  table.border.bottom.style = NULL,
  table.border.bottom.width = NULL,
  table.border.bottom.color = NULL,
  table.border.left.style = NULL,
  table.border.left.width = NULL,
  table.border.left.color = NULL,
  heading.background.color = NULL,
  heading.align = NULL,
  heading.title.font.size = NULL,
  heading.title.font.weight = NULL,
  heading.subtitle.font.size = NULL,
  heading.subtitle.font.weight = NULL,
  heading.padding = NULL,
  heading.padding.horizontal = NULL,
  heading.border.bottom.style = NULL,
  heading.border.bottom.width = NULL,
  heading.border.bottom.color = NULL,
  heading.border.lr.style = NULL,
  heading.border.lr.width = NULL,
  heading.border.lr.color = NULL,
  column_labels.background.color = NULL,
  column_labels.font.size = NULL,
  column_labels.font.weight = NULL,
  column_labels.text_transform = NULL,
  column_labels.padding = NULL,
  column_labels.padding.horizontal = NULL,
  column_labels.vlines.style = NULL,
  column_labels.vlines.width = NULL,
  column_labels.vlines.color = NULL,
  column_labels.border.top.style = NULL,
  column_labels.border.top.width = NULL,
  column_labels.border.top.color = NULL,
  column_labels.border.bottom.style = NULL,
  column_labels.border.bottom.width = NULL,
  column_labels.border.bottom.color = NULL,
  column_labels.border.lr.style = NULL,
  column_labels.border.lr.width = NULL,
  column_labels.border.lr.color = NULL,
  column_labels.hidden = NULL,
  row_group.background.color = NULL,
  row_group.font.size = NULL,
  row_group.font.weight = NULL,
  row_group.text_transform = NULL,
  row_group.padding = NULL,
  row_group.padding.horizontal = NULL,
  row_group.border.top.style = NULL,
  row_group.border.top.width = NULL,
  row_group.border.top.color = NULL,
  row_group.border.bottom.style = NULL,
  row_group.border.bottom.width = NULL,
  row_group.border.bottom.color = NULL,
  row_group.border.left.style = NULL,
  row_group.border.left.width = NULL,
  row_group.border.left.color = NULL,
  row_group.border.right.style = NULL,
  row_group.border.right.width = NULL,
  row_group.border.right.color = NULL,
  row_group.default_label = NULL,
  row_group.as_column = NULL,
  table_body.hlines.style = NULL,
  table_body.hlines.width = NULL,
  table_body.hlines.color = NULL,
  table_body.vlines.style = NULL,
  table_body.vlines.width = NULL,
  table_body.vlines.color = NULL,
  table_body.border.top.style = NULL,
  table_body.border.top.width = NULL,
  table_body.border.top.color = NULL,
  table_body.border.bottom.style = NULL,
  table_body.border.bottom.width = NULL,
  table_body.border.bottom.color = NULL,
  stub.background.color = NULL,
  stub.font.size = NULL,
  stub.font.weight = NULL,
  stub.text_transform = NULL,
  stub.border.style = NULL,
  stub.border.width = NULL,
  stub.border.color = NULL,
  stub_row_group.font.size = NULL,
  stub_row_group.font.weight = NULL,
  stub_row_group.text_transform = NULL,
  stub_row_group.border.style = NULL,
  stub_row_group.border.width = NULL,
  stub_row_group.border.color = NULL,
  data_row.padding = NULL,
  data_row.padding.horizontal = NULL,
  summary_row.background.color = NULL,
  summary_row.text_transform = NULL,
  summary_row.padding = NULL,
  summary_row.padding.horizontal = NULL,
  summary_row.border.style = NULL,
  summary_row.border.width = NULL,
  summary_row.border.color = NULL,
  grand_summary_row.background.color = NULL,
  grand_summary_row.text_transform = NULL,
  grand_summary_row.padding = NULL,
  grand_summary_row.padding.horizontal = NULL,
  grand_summary_row.border.style = NULL,
  grand_summary_row.border.width = NULL,
  grand_summary_row.border.color = NULL,
  footnotes.background.color = NULL,
  footnotes.font.size = NULL,
  footnotes.padding = NULL,
  footnotes.padding.horizontal = NULL,
  footnotes.border.bottom.style = NULL,
  footnotes.border.bottom.width = NULL,
  footnotes.border.bottom.color = NULL,
  footnotes.border.lr.style = NULL,
  footnotes.border.lr.width = NULL,
  footnotes.border.lr.color = NULL,
  footnotes.marks = NULL,
  footnotes.multiline = NULL,
  footnotes.sep = NULL,
  source_notes.background.color = NULL,
  source_notes.font.size = NULL,
  source_notes.padding = NULL,
  source_notes.padding.horizontal = NULL,
  source_notes.border.bottom.style = NULL,
  source_notes.border.bottom.width = NULL,
  source_notes.border.bottom.color = NULL,
  source_notes.border.lr.style = NULL,
  source_notes.border.lr.width = NULL,
  source_notes.border.lr.color = NULL,
  source_notes.multiline = NULL,
  source_notes.sep = NULL,
  row.striping.background_color = NULL,
  row.striping.include_stub = NULL,
  row.striping.include_table_body = NULL
)
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{container.width, container.height}{The width and height of the table's
container. Can be specified as a single-length character with units of
pixels or as a percentage. If provided as a single-length numeric vector,
it is assumed that the value is given in units of pixels. The \code{\link[=px]{px()}} and
\code{\link[=pct]{pct()}} helper functions can also be used to pass in numeric values and
obtain values as pixel or percent units.}

\item{container.overflow.x, container.overflow.y}{Options to enable scrolling
in the horizontal and vertical directions when the table content overflows
the container dimensions. Using \code{TRUE} (the default for both) means that
horizontal or vertical scrolling is enabled to view the entire table in
those directions. With \code{FALSE}, the table may be clipped if the table width
or height exceeds the \code{container.width} or \code{container.height}.}

\item{table.width}{The width of the table. Can be specified as a
single-length character with units of pixels or as a percentage. If
provided as a single-length numeric vector, it is assumed that the value is
given in units of pixels. The \code{\link[=px]{px()}} and \code{\link[=pct]{pct()}} helper functions can also
be used to pass in numeric values and obtain values as pixel or percent
units.}

\item{table.layout}{The value for the \code{table-layout} CSS style in the HTML
output context. By default, this is \code{"fixed"} but another valid option is
\code{"auto"}.}

\item{table.align}{The horizontal alignment of the table in its container. By
default, this is \code{"center"}. Other options are \code{"left"} and \code{"right"}. This
will automatically set \code{table.margin.left} and \code{table.margin.right} to the
appropriate values.}

\item{table.margin.left, table.margin.right}{The size of the margins on the
left and right of the table within the container. Can be specified as a
single-length character with units of pixels or as a percentage. If
provided as a single-length numeric vector, it is assumed that the value is
given in units of pixels. The \code{\link[=px]{px()}} and \code{\link[=pct]{pct()}} helper functions can also
be used to pass in numeric values and obtain values as pixel or percent
units. Using \code{table.margin.left} or \code{table.margin.right} will overwrite any
values set by \code{table.align}.}

\item{table.background.color, heading.background.color, column_labels.background.color, row_group.background.color, stub.background.color, summary_row.background.color, grand_summary_row.background.color, footnotes.background.color, source_notes.background.color}{Background colors for the parent element \code{table} and the following child
elements: \code{heading}, \code{column_labels}, \code{row_group}, \code{stub}, \code{summary_row},
\code{grand_summary_row}, \code{footnotes}, and \code{source_notes}. A color name or a
hexadecimal color code should be provided.}

\item{table.additional_css}{This option can be used to supply an additional
block of CSS rules to be applied after the automatically generated table
CSS.}

\item{table.font.names}{The names of the fonts used for the table. This is
a vector of several font names. If the first font isn't available, then
the next font is tried (and so on).}

\item{table.font.size, heading.title.font.size, heading.subtitle.font.size, column_labels.font.size, row_group.font.size, stub.font.size, footnotes.font.size, source_notes.font.size}{The font sizes for the parent text element \code{table} and the following child
elements: \code{heading.title}, \code{heading.subtitle}, \code{column_labels},
\code{row_group}, \code{footnotes}, and \code{source_notes}. Can be specified as a
single-length character vector with units of pixels (e.g., \verb{12px}) or as a
percentage (e.g., \verb{80\\\%}). If provided as a single-length numeric vector,
it is assumed that the value is given in units of pixels. The \code{\link[=px]{px()}} and
\code{\link[=pct]{pct()}} helper functions can also be used to pass in numeric values and
obtain values as pixel or percentage units.}

\item{table.font.weight, heading.title.font.weight, heading.subtitle.font.weight, column_labels.font.weight, row_group.font.weight, stub.font.weight}{The font weights of the table, \code{heading.title}, \code{heading.subtitle},
\code{column_labels}, \code{row_group}, and \code{stub} text elements. Can be a text-based
keyword such as \code{"normal"}, \code{"bold"}, \code{"lighter"}, \code{"bolder"}, or, a
numeric value between \code{1} and \code{1000}, inclusive. Note that only variable
fonts may support the numeric mapping of weight.}

\item{table.font.style}{The font style for the table. Can be one of either
\code{"normal"}, \code{"italic"}, or \code{"oblique"}.}

\item{table.font.color, table.font.color.light}{The text color used throughout the table. There are two variants:
\code{table.font.color} is for text overlaid on lighter background colors, and
\code{table.font.color.light} is automatically used when text needs to be
overlaid on darker background colors. A color name or a hexadecimal color
code should be provided.}

\item{table.border.top.style, table.border.top.width, table.border.top.color, table.border.right.style, table.border.right.width, table.border.right.color, table.border.bottom.style, table.border.bottom.width, table.border.bottom.color, table.border.left.style, table.border.left.width, table.border.left.color}{The style, width, and color properties of the table's absolute top and
absolute bottom borders.}

\item{heading.align}{Controls the horizontal alignment of the heading title
and subtitle. We can either use \code{"center"}, \code{"left"}, or \code{"right"}.}

\item{heading.padding, column_labels.padding, data_row.padding, row_group.padding, summary_row.padding, grand_summary_row.padding, footnotes.padding, source_notes.padding}{The amount of vertical padding to incorporate in the \code{heading} (title and
subtitle), the \code{column_labels} (this includes the column spanners), the row
group labels (\code{row_group.padding}), in the body/stub rows
(\code{data_row.padding}), in summary rows (\code{summary_row.padding} or
\code{grand_summary_row.padding}), or in the footnotes and source notes
(\code{footnotes.padding} and \code{source_notes.padding}).}

\item{heading.padding.horizontal, column_labels.padding.horizontal, data_row.padding.horizontal, row_group.padding.horizontal, summary_row.padding.horizontal, grand_summary_row.padding.horizontal, footnotes.padding.horizontal, source_notes.padding.horizontal}{The amount of horizontal padding to incorporate in the \code{heading} (title and
subtitle), the \code{column_labels} (this includes the column spanners), the row
group labels (\code{row_group.padding.horizontal}), in the body/stub rows
(\code{data_row.padding}), in summary rows (\code{summary_row.padding.horizontal} or
\code{grand_summary_row.padding.horizontal}), or in the footnotes and source
notes (\code{footnotes.padding.horizontal} and
\code{source_notes.padding.horizontal}).}

\item{heading.border.bottom.style, heading.border.bottom.width, heading.border.bottom.color}{The style, width, and color properties of the header's bottom border. This
border shares space with that of the \code{column_labels} location. If the
\code{width} of this border is larger, then it will be the visible border.}

\item{heading.border.lr.style, heading.border.lr.width, heading.border.lr.color}{The style, width, and color properties for the left and right borders of
the \code{heading} location.}

\item{column_labels.text_transform, row_group.text_transform, stub.text_transform, summary_row.text_transform, grand_summary_row.text_transform}{Options to apply text transformations to the \code{column_labels}, \code{row_group},
\code{stub}, \code{summary_row}, and \code{grand_summary_row} text elements. Either of the
\code{"uppercase"}, \code{"lowercase"}, or \code{"capitalize"} keywords can be used.}

\item{column_labels.vlines.style, column_labels.vlines.width, column_labels.vlines.color}{The style, width, and color properties for all vertical lines ('vlines')
of the the \code{column_labels}.}

\item{column_labels.border.top.style, column_labels.border.top.width, column_labels.border.top.color}{The style, width, and color properties for the top border of the
\code{column_labels} location. This border shares space with that of the
\code{heading} location. If the \code{width} of this border is larger, then it will
be the visible border.}

\item{column_labels.border.bottom.style, column_labels.border.bottom.width, column_labels.border.bottom.color}{The style, width, and color properties for the bottom border of the
\code{column_labels} location.}

\item{column_labels.border.lr.style, column_labels.border.lr.width, column_labels.border.lr.color}{The style, width, and color properties for the left and right borders of
the \code{column_labels} location.}

\item{column_labels.hidden}{An option to hide the column labels. If providing
\code{TRUE} then the entire \code{column_labels} location won't be seen and the table
header (if present) will collapse downward.}

\item{row_group.border.top.style, row_group.border.top.width, row_group.border.top.color, row_group.border.bottom.style, row_group.border.bottom.width, row_group.border.bottom.color, row_group.border.left.style, row_group.border.left.width, row_group.border.left.color, row_group.border.right.style, row_group.border.right.width, row_group.border.right.color}{The style, width, and color properties for all top, bottom, left, and right
borders of the \code{row_group} location.}

\item{row_group.default_label}{An option to set a default row group label for
any rows not formally placed in a row group named by \code{group} in any call of
\code{tab_row_group()}. If this is set as \code{NA_character} and there are rows that
haven't been placed into a row group (where one or more row groups already
exist), those rows will be automatically placed into a row group without a
label.}

\item{row_group.as_column}{How should row groups be structured? By default,
they are separate rows that lie above the each of the groups. Setting this
to \code{TRUE} will structure row group labels are columns to the far left of
the table.}

\item{table_body.hlines.style, table_body.hlines.width, table_body.hlines.color, table_body.vlines.style, table_body.vlines.width, table_body.vlines.color}{The style, width, and color properties for all horizontal lines ('hlines')
and vertical lines ('vlines') in the \code{table_body}.}

\item{table_body.border.top.style, table_body.border.top.width, table_body.border.top.color, table_body.border.bottom.style, table_body.border.bottom.width, table_body.border.bottom.color}{The style, width, and color properties for all top and bottom borders of
the \code{table_body} location.}

\item{stub.border.style, stub.border.width, stub.border.color}{The style, width, and color properties for the vertical border of the table
stub.}

\item{stub_row_group.font.size, stub_row_group.font.weight, stub_row_group.text_transform, stub_row_group.border.style, stub_row_group.border.width, stub_row_group.border.color}{Options for the row group column in the stub (made possible when using
\code{row_group.as_column = TRUE}). The defaults for these options mirror that
of the \verb{stub.*} variants (except for \code{stub_row_group.border.width}, which
is \code{"1px"} instead of \code{"2px"}).}

\item{summary_row.border.style, summary_row.border.width, summary_row.border.color}{The style, width, and color properties for all horizontal borders of the
\code{summary_row} location.}

\item{grand_summary_row.border.style, grand_summary_row.border.width, grand_summary_row.border.color}{The style, width, and color properties for the top borders of the
\code{grand_summary_row} location.}

\item{footnotes.border.bottom.style, footnotes.border.bottom.width, footnotes.border.bottom.color}{The style, width, and color properties for the bottom border of the
\code{footnotes} location.}

\item{footnotes.border.lr.style, footnotes.border.lr.width, footnotes.border.lr.color}{The style, width, and color properties for the left and right borders of
the \code{footnotes} location.}

\item{footnotes.marks}{The set of sequential marks used to reference and
identify each of the footnotes (same input as the \code{\link[=opt_footnote_marks]{opt_footnote_marks()}}
function. We can supply a vector that represents the series of footnote
marks. This vector is recycled when its usage goes beyond the length of the
set. At each cycle, the marks are simply combined (e.g., \code{*} -> \verb{**} ->
\verb{***}). The option exists for providing keywords for certain types of
footnote marks. The keyword \code{"numbers"} (the default, indicating that we
want to use numeric marks). We can use lowercase \code{"letters"} or uppercase
\code{"LETTERS"}. There is the option for using a traditional symbol set where
\code{"standard"} provides four symbols, and, \code{"extended"} adds two more
symbols, making six.}

\item{footnotes.multiline, source_notes.multiline}{An option to either put
footnotes and source notes in separate lines (the default, or \code{TRUE}) or
render them as a continuous line of text with \code{footnotes.sep} providing the
separator (by default \code{" "}) between notes.}

\item{footnotes.sep, source_notes.sep}{The separating characters between
adjacent footnotes and source notes in their respective footer sections
when rendered as a continuous line of text (when
\code{footnotes.multiline == FALSE}). The default value is a single space
character (\code{" "}).}

\item{source_notes.border.bottom.style, source_notes.border.bottom.width, source_notes.border.bottom.color}{The style, width, and color properties for the bottom border of the
\code{source_notes} location.}

\item{source_notes.border.lr.style, source_notes.border.lr.width, source_notes.border.lr.color}{The style, width, and color properties for the left and right borders of
the \code{source_notes} location.}

\item{row.striping.background_color}{The background color for striped table
body rows. A color name or a hexadecimal color code should be provided.}

\item{row.striping.include_stub}{An option for whether to include the stub
when striping rows.}

\item{row.striping.include_table_body}{An option for whether to include the
table body when striping rows.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
Modify the options available in a table. These options are named by the
components, the subcomponents, and the element that can adjusted.
}
\section{Figures}{

\if{html}{\figure{man_tab_options_1.png}{options: width=100\%}}

\if{html}{\figure{man_tab_options_2.png}{options: width=100\%}}

\if{html}{\figure{man_tab_options_3.png}{options: width=100\%}}

\if{html}{\figure{man_tab_options_4.png}{options: width=100\%}}

\if{html}{\figure{man_tab_options_5.png}{options: width=100\%}}

\if{html}{\figure{man_tab_options_6.png}{options: width=100\%}}
}

\section{Function ID}{

2-9
}

\examples{
# Use `exibble` to create a gt table with
# all the main parts added; we can use this
# going forward to demo some `tab_options()`
tab_1 <-
  exibble \%>\%
  dplyr::select(
    -c(fctr, date, time, datetime)
  ) \%>\%
  gt(
    rowname_col = "row",
    groupname_col = "group"
  ) \%>\%
  tab_header(
    title = md("Data listing from **exibble**"),
    subtitle = md("`exibble` is an R dataset")
  ) \%>\%
  fmt_number(columns = num) \%>\%
  fmt_currency(columns = currency) \%>\%
  tab_footnote(
    footnote = "Using commas for separators.",
    locations = cells_body(
      columns = num,
      rows = num > 1000
    )
  ) \%>\%
  tab_footnote(
    footnote = "Using commas for separators.",
    locations = cells_body(
      columns = currency,
      rows = currency > 1000
    )
  ) \%>\%
  tab_footnote(
    footnote = "Alphabetical fruit.",
    locations = cells_column_labels(
      columns = char
    )
  )

# Modify the table width to 100\% (which
# spans the entire content width area)
tab_2 <-
  tab_1 \%>\%
  tab_options(
    table.width = pct(100)
  )

# Modify the table's background color
# to be "lightcyan"
tab_3 <-
  tab_1 \%>\%
  tab_options(
    table.background.color = "lightcyan"
  )

# Use letters as the marks for footnote
# references; also, separate footnotes in
# the footer by spaces instead of newlines
tab_4 <-
  tab_1 \%>\%
  tab_options(
    footnotes.sep = " ",
    footnotes.marks = letters
  )

# Change the padding of data rows to 5px
tab_5 <-
  tab_1 \%>\%
  tab_options(
    data_row.padding = px(5)
  )

# Reduce the size of the title and the
# subtitle text
tab_6 <-
  tab_1 \%>\%
  tab_options(
    heading.title.font.size = "small",
    heading.subtitle.font.size = "small"
  )

}
\seealso{
Other Create or Modify Parts: 
\code{\link{tab_footnote}()},
\code{\link{tab_header}()},
\code{\link{tab_row_group}()},
\code{\link{tab_source_note}()},
\code{\link{tab_spanner_delim}()},
\code{\link{tab_spanner}()},
\code{\link{tab_stubhead}()},
\code{\link{tab_style}()}
}
\concept{Create or Modify Parts}
