% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{pct}
\alias{pct}
\title{Helper for providing a numeric value as percentage}
\usage{
pct(x)
}
\arguments{
\item{x}{the numeric value to format as a string percentage for some
\code{\link[=tab_options]{tab_options()}} arguments that can take percentage values
(e.g., \code{table.width}).}
}
\value{
A character vector with a single value in percentage units.
}
\description{
A percentage value acts as a length value that is relative to an initial
state. For instance an 80 percent value for something will size the target
to 80 percent the size of its 'previous' value. This type of sizing is
useful for sizing up or down a length value with an intuitive measure. This
helper function can be used for the setting of font sizes (e.g., in
\code{\link[=cell_text]{cell_text()}}) and altering the thicknesses of lines (e.g., in
\code{\link[=cell_borders]{cell_borders()}}). Should a more exact definition of size be required, the
analogous helper function \code{\link[=pct]{pct()}} will be more useful.
}
\section{Examples}{


Use \code{\link{exibble}} to create a \strong{gt} table. Use the \code{pct()} helper to define
the font size for the column labels.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{exibble \%>\%
  gt() \%>\%
  tab_style(
    style = cell_text(size = pct(75)),
    locations = cells_column_labels()
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_pct_1.png" style="width:100\%;">
}}
}

\section{Function ID}{

7-4
}

\seealso{
Other Helper Functions: 
\code{\link{adjust_luminance}()},
\code{\link{cell_borders}()},
\code{\link{cell_fill}()},
\code{\link{cell_text}()},
\code{\link{cells_body}()},
\code{\link{cells_column_labels}()},
\code{\link{cells_column_spanners}()},
\code{\link{cells_footnotes}()},
\code{\link{cells_grand_summary}()},
\code{\link{cells_row_groups}()},
\code{\link{cells_source_notes}()},
\code{\link{cells_stub_grand_summary}()},
\code{\link{cells_stub_summary}()},
\code{\link{cells_stubhead}()},
\code{\link{cells_stub}()},
\code{\link{cells_summary}()},
\code{\link{cells_title}()},
\code{\link{currency}()},
\code{\link{default_fonts}()},
\code{\link{escape_latex}()},
\code{\link{google_font}()},
\code{\link{gt_latex_dependencies}()},
\code{\link{html}()},
\code{\link{md}()},
\code{\link{px}()},
\code{\link{random_id}()}
}
\concept{Helper Functions}
