% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{as_word}
\alias{as_word}
\title{Output a \strong{gt} object as Word}
\usage{
as_word(
  data,
  align = "center",
  caption_location = c("top", "bottom", "embed"),
  caption_align = "left",
  split = FALSE,
  keep_with_next = TRUE
)
}
\arguments{
\item{data}{A table object that is created using the \code{gt()} function.}

\item{align}{left, center (default) or right.}

\item{caption_location}{top (default), bottom, or embed Indicating if the
title and subtitle should be listed above, below, or be embedded in the
table}

\item{caption_align}{left (default), center, or right. Alignment of caption
(title and subtitle). Used when \code{caption_location} is not "embed".}

\item{split}{TRUE or FALSE (default) indicating whether activate Word option
'Allow row to break across pages'.}

\item{keep_with_next}{TRUE (default) or FALSE indicating whether a table
should use Word option 'keep rows together' is activated when TRUEd}
}
\description{
Get the Open Office XML table tag content from a \code{gt_tbl} object as as a
single-element character vector.
}
\section{Function ID}{

13-5
}

\examples{
# Use `gtcars` to create a gt table;
# add a header and then export as
# OOXML code for Word
tab_rtf <-
  gtcars \%>\%
  dplyr::select(mfr, model) \%>\%
  dplyr::slice(1:2) \%>\%
  gt() \%>\%
  tab_header(
    title = md("Data listing from **gtcars**"),
    subtitle = md("`gtcars` is an R dataset")
  ) \%>\%
  as_word()

}
\seealso{
Other table export functions: 
\code{\link{as_latex}()},
\code{\link{as_raw_html}()},
\code{\link{as_rtf}()},
\code{\link{extract_summary}()},
\code{\link{gtsave}()}
}
\concept{table export functions}
