% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_data.R
\name{fmt_date}
\alias{fmt_date}
\title{Format values as dates}
\usage{
fmt_date(
  data,
  columns,
  rows = everything(),
  date_style = "iso",
  pattern = "{x}",
  locale = NULL
)
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{columns}{The columns to format. Can either be a series of column names
provided in \code{\link[=c]{c()}}, a vector of column indices, or a helper function
focused on selections. The select helper functions are: \code{\link[=starts_with]{starts_with()}},
\code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}}, \code{\link[=one_of]{one_of()}}, \code{\link[=num_range]{num_range()}}, and
\code{\link[=everything]{everything()}}.}

\item{rows}{Optional rows to format. Providing \code{\link[=everything]{everything()}} (the
default) results in all rows in \code{columns} being formatted. Alternatively,
we can supply a vector of row captions within \code{\link[=c]{c()}}, a vector of row
indices, or a helper function focused on selections. The select helper
functions are: \code{\link[=starts_with]{starts_with()}}, \code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}},
\code{\link[=one_of]{one_of()}}, \code{\link[=num_range]{num_range()}}, and \code{\link[=everything]{everything()}}. We can also use expressions
to filter down to the rows we need (e.g.,
\verb{[colname_1] > 100 & [colname_2] < 50}).}

\item{date_style}{The date style to use. By default this is \code{"iso"} which
corresponds to ISO 8601 date formatting. The other date styles can be
viewed using \code{\link[=info_date_style]{info_date_style()}}.}

\item{pattern}{A formatting pattern that allows for decoration of the
formatted value. The value itself is represented by \code{{x}} and all other
characters are taken to be string literals.}

\item{locale}{An optional locale ID that can be used for formatting the value
according the locale's rules. Examples include \code{"en"} for English (United
States) and \code{"fr"} for French (France). The use of a valid locale ID will
override any values provided in \code{sep_mark} and \code{dec_mark}. We can use the
\code{\link[=info_locales]{info_locales()}} function as a useful reference for all of the locales that
are supported. Any \code{locale} value provided here will override any global
locale setting performed in \code{\link[=gt]{gt()}}'s own \code{locale} argument.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
Format input values to time values using one of 41 preset date styles. Input
can be in the form of \code{POSIXt} (i.e., datetimes), the \code{Date} type, or
\code{character} (must be in the ISO 8601 form of \verb{YYYY-MM-DD HH:MM:SS} or
\code{YYYY-MM-DD}).
}
\section{Targeting the values to be formatted}{


Targeting of values is done through \code{columns} and additionally by \code{rows} (if
nothing is provided for \code{rows} then entire columns are selected). Conditional
formatting is possible by providing a conditional expression to the \code{rows}
argument. See the \emph{Arguments} section for more information on this.
}

\section{Formatting with the \code{date_style} argument}{


We need to supply a preset date style to the \code{date_style} argument. The date
styles are numerous and can handle localization to any supported locale. A
large segment of date styles are termed flexible date formats and this means
that their output will adapt to any \code{locale} provided. That feature makes the
flexible date formats a better option for locales other than \code{"en"} (the
default locale).

The following table provides a listing of all date styles and their output
values (corresponding to an input date of \code{2000-02-29}).\tabular{llll}{
    \tab Date Style \tab Output \tab Notes \cr
   1 \tab \code{"iso"} \tab \code{"2000-02-29"} \tab ISO 8601 \cr
   2 \tab \code{"wday_month_day_year"} \tab \code{"Tuesday, February 29, 2000"} \tab  \cr
   3 \tab \code{"wd_m_day_year"} \tab \code{"Tue, Feb 29, 2000"} \tab  \cr
   4 \tab \code{"wday_day_month_year"} \tab \code{"Tuesday 29 February 2000"} \tab  \cr
   5 \tab \code{"month_day_year"} \tab \code{"February 29, 2000"} \tab  \cr
   6 \tab \code{"m_day_year"} \tab \code{"Feb 29, 2000"} \tab  \cr
   7 \tab \code{"day_m_year"} \tab \code{"29 Feb 2000"} \tab  \cr
   8 \tab \code{"day_month_year"} \tab \code{"29 February 2000"} \tab  \cr
   9 \tab \code{"day_month"} \tab \code{"29 February"} \tab  \cr
   10 \tab \code{"day_m"} \tab \code{"29 Feb"} \tab  \cr
   11 \tab \code{"year"} \tab \code{"2000"} \tab  \cr
   12 \tab \code{"month"} \tab \code{"February"} \tab  \cr
   13 \tab \code{"day"} \tab \code{"29"} \tab  \cr
   14 \tab \code{"year.mn.day"} \tab \code{"2000/02/29"} \tab  \cr
   15 \tab \code{"y.mn.day"} \tab \code{"00/02/29"} \tab  \cr
   16 \tab \code{"year_week"} \tab \code{"2000-W09"} \tab  \cr
   17 \tab \code{"year_quarter"} \tab \code{"2000-Q1"} \tab  \cr
   18 \tab \code{"yMd"} \tab \code{"2/29/2000"} \tab flexible \cr
   19 \tab \code{"yMEd"} \tab \code{"Tue, 2/29/2000"} \tab flexible \cr
   20 \tab \code{"yMMM"} \tab \code{"Feb 2000"} \tab flexible \cr
   21 \tab \code{"yMMMM"} \tab \code{"February 2000"} \tab flexible \cr
   22 \tab \code{"yMMMd"} \tab \code{"Feb 29, 2000"} \tab flexible \cr
   23 \tab \code{"yMMMEd"} \tab \code{"Tue, Feb 29, 2000"} \tab flexible \cr
   24 \tab \code{"GyMd"} \tab \code{"2/29/2000 A"} \tab flexible \cr
   25 \tab \code{"GyMMMd"} \tab \code{"Feb 29, 2000 AD"} \tab flexible \cr
   26 \tab \code{"GyMMMEd"} \tab \code{"Tue, Feb 29, 2000 AD"} \tab flexible \cr
   27 \tab \code{"yM"} \tab \code{"2/2000"} \tab flexible \cr
   28 \tab \code{"Md"} \tab \code{"2/29"} \tab flexible \cr
   29 \tab \code{"MEd"} \tab \code{"Tue, 2/29"} \tab flexible \cr
   30 \tab \code{"MMMd"} \tab \code{"Feb 29"} \tab flexible \cr
   31 \tab \code{"MMMEd"} \tab \code{"Tue, Feb 29"} \tab flexible \cr
   32 \tab \code{"MMMMd"} \tab \code{"February 29"} \tab flexible \cr
   33 \tab \code{"GyMMM"} \tab \code{"Feb 2000 AD"} \tab flexible \cr
   34 \tab \code{"yQQQ"} \tab \code{"Q1 2000"} \tab flexible \cr
   35 \tab \code{"yQQQQ"} \tab \code{"1st quarter 2000"} \tab flexible \cr
   36 \tab \code{"Gy"} \tab \code{"2000 AD"} \tab flexible \cr
   37 \tab \code{"y"} \tab \code{"2000"} \tab flexible \cr
   38 \tab \code{"M"} \tab \code{"2"} \tab flexible \cr
   39 \tab \code{"MMM"} \tab \code{"Feb"} \tab flexible \cr
   40 \tab \code{"d"} \tab \code{"29"} \tab flexible \cr
   41 \tab \code{"Ed"} \tab \code{"29 Tue"} \tab flexible \cr
}


We can use the \code{\link[=info_date_style]{info_date_style()}} within the console to view a similar table
of date styles with example output.
}

\section{Examples}{


Use \code{\link{exibble}} to create a \strong{gt} table. Keep only the \code{date} and \code{time}
columns. Format the \code{date} column to have dates formatted with the
\code{"month_day_year"} date style.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{exibble \%>\%
  dplyr::select(date, time) \%>\%
  gt() \%>\%
  fmt_date(
    columns = date,
    date_style = "month_day_year"
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_fmt_date_1.png" alt="This image of a table was generated from the first code example in the `fmt_date()` help file." style="width:100\%;">
}}

Use \code{\link{exibble}} to create a \strong{gt} table. Keep only the \code{date} and \code{time}
columns. Format the \code{date} column to have mixed date formats (dates after
April will be different than the others because of the expressions used
in the \code{rows} argument).

\if{html}{\out{<div class="sourceCode r">}}\preformatted{exibble \%>\%
  dplyr::select(date, time) \%>\%
  gt() \%>\%
  fmt_date(
    columns = date,
    rows = as.Date(date) > as.Date("2015-04-01"),
    date_style = "m_day_year"
  ) \%>\%
  fmt_date(
    columns = date,
    rows = as.Date(date) <= as.Date("2015-04-01"),
    date_style = "day_m_year"
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_fmt_date_2.png" alt="This image of a table was generated from the second code example in the `fmt_date()` help file." style="width:100\%;">
}}

Use \code{\link{exibble}} to create another \strong{gt} table, this time only with the
\code{date} column. Format the \code{date} column to use the \code{"yMMMEd"} date style
(which is one of the 'flexible' styles). Also, set the locale to \code{"nl"} to
get the dates in Dutch.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{exibble \%>\%
  dplyr::select(date) \%>\%
  gt() \%>\%
  fmt_date(
    columns = date,
    date_style = "yMMMEd",
    locale = "nl"
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_fmt_date_3.png" alt="This image of a table was generated from the third code example in the `fmt_date()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

3-11
}

\seealso{
Other data formatting functions: 
\code{\link{data_color}()},
\code{\link{fmt_bytes}()},
\code{\link{fmt_currency}()},
\code{\link{fmt_datetime}()},
\code{\link{fmt_duration}()},
\code{\link{fmt_engineering}()},
\code{\link{fmt_fraction}()},
\code{\link{fmt_integer}()},
\code{\link{fmt_markdown}()},
\code{\link{fmt_number}()},
\code{\link{fmt_partsper}()},
\code{\link{fmt_passthrough}()},
\code{\link{fmt_percent}()},
\code{\link{fmt_roman}()},
\code{\link{fmt_scientific}()},
\code{\link{fmt_time}()},
\code{\link{fmt}()},
\code{\link{sub_large_vals}()},
\code{\link{sub_missing}()},
\code{\link{sub_small_vals}()},
\code{\link{sub_values}()},
\code{\link{sub_zero}()},
\code{\link{text_transform}()}
}
\concept{data formatting functions}
