% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_image_rows.R
\name{gt_img_rows}
\alias{gt_img_rows}
\title{Add local or web images into rows of a \code{gt} table}
\usage{
gt_img_rows(gt_object, columns, img_source = "web", height = 30)
}
\arguments{
\item{gt_object}{An existing gt table object of class \code{gt_tbl}}

\item{columns}{The columns wherein changes to cell data colors should occur.}

\item{img_source}{A string, specifying either "local" or "web" as the source of the images.}

\item{height}{\emph{Height of image}

\verb{scalar<numeric|integer>} // \emph{default:} \code{30}

The absolute height of the image in the table cell (in \code{"px"} units). By
default, this is set to \code{"30px"}.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
The \code{gt_img_rows} function takes an existing \code{gt_tbl} object and
converts filenames or urls to images into inline images. This is a wrapper
around \code{gt::text_transform()} + \code{gt::web_image()}/\code{gt::local_image()} with
the necessary boilerplate already applied.
}
\section{Examples}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(gt)
teams <- "https://github.com/nflverse/nflfastR-data/raw/master/teams_colors_logos.rds"
team_df <- readRDS(url(teams))

 logo_table <- team_df \%>\%
   dplyr::select(team_wordmark, team_abbr, logo = team_logo_espn, team_name:team_conf) \%>\%
   head() \%>\%
   gt() \%>\%
   gt_img_rows(columns = team_wordmark, height = 25) \%>\%
   gt_img_rows(columns = logo, img_source = "web", height = 30) \%>\%
   tab_options(data_row.padding = px(1))
}\if{html}{\out{</div>}}
}

\section{Figures}{

\if{html}{\figure{img-rows.png}{options: width=100\%}}
}

\section{Function ID}{

2-7
}

\seealso{
Other Utilities: 
\code{\link{add_text_img}()},
\code{\link{fa_icon_repeat}()},
\code{\link{fmt_pad_num}()},
\code{\link{fmt_pct_extra}()},
\code{\link{fmt_symbol_first}()},
\code{\link{generate_df}()},
\code{\link{gt_add_divider}()},
\code{\link{gt_badge}()},
\code{\link{gt_double_table}()},
\code{\link{gt_duplicate_column}()},
\code{\link{gt_fa_rank_change}()},
\code{\link{gt_fa_rating}()},
\code{\link{gt_highlight_cols}()},
\code{\link{gt_highlight_rows}()},
\code{\link{gt_img_border}()},
\code{\link{gt_img_circle}()},
\code{\link{gt_img_multi_rows}()},
\code{\link{gt_index}()},
\code{\link{gt_merge_stack}()},
\code{\link{gt_merge_stack_color}()},
\code{\link{gt_two_column_layout}()},
\code{\link{gtsave_extra}()},
\code{\link{img_header}()},
\code{\link{pad_fn}()},
\code{\link{tab_style_by_grp}()}
}
\concept{Utilities}
