% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_gtfs.R
\name{filter_single_trip}
\alias{filter_single_trip}
\title{Filter GTFS trips in order to have one trip per shape_id}
\usage{
filter_single_trip(gtfs_data, remove_invalid = TRUE)
}
\arguments{
\item{gtfs_data}{A list of data.tables read using gtfs2gps::reag_gtfs().}

\item{remove_invalid}{Remove all the invalid objects after subsetting the data?
The default value is TRUE.}
}
\value{
A filtered GTFS data.
}
\description{
Filter a GTFS data by keeping only one trip per shape_id.
It also removes the unnecessary routes accordingly.
}
\examples{
poa <- read_gtfs(system.file("extdata/poa.zip", package = "gtfs2gps"))

subset <- filter_single_trip(poa)
}
