% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_gtfs.R
\name{remove_invalid}
\alias{remove_invalid}
\title{Remove invalid objects from GTFS data}
\usage{
remove_invalid(gtfs_data, only_essential = TRUE, prompt_invalid = FALSE)
}
\arguments{
\item{gtfs_data}{A list of data.tables read using gtfs2gps::reag_gtfs().}

\item{only_essential}{Remove only the essential files? The essential files are all but 
agency, calendar, and routes. Default is TRUE, which means that agency-routes,
routes-trips, and trips-calendar relations
will not be processed as restrictions to remove objects.}

\item{prompt_invalid}{Show the invalid objects. Default is FALSE.}
}
\value{
A subset of the input GTFS data.
}
\description{
Remove all objects from GTFS data that are not used in all relations
that they are required to be. That is,
agency-routes relation (agency_id), routes-trips relation (route_id), 
trips-shapes relation (shape_id), trips-frequencies relation (trip_id),
trips-stop_times relation (trip_id), stop_times-stops relation (stop_id),
and trips-calendar relation (service_id),
recursively, until GTFS data does not reduce its size anymore. For example,
if one agency_id belongs to routes but not to agency will be removed. This might
cause one cascade removal of objects in other relations that originally
did not have any inconsistency.
}
\examples{
poa <- read_gtfs(system.file("extdata/poa.zip", package = "gtfs2gps"))
object.size(poa)
subset <- remove_invalid(poa)
object.size(subset)
}
