% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gps_as_sflinestring.R
\name{gps_as_sflinestring}
\alias{gps_as_sflinestring}
\title{Converts a GPS-like data.table to a LineString Simple Feature (sf) object}
\usage{
gps_as_sflinestring(gps)
}
\arguments{
\item{gps}{A data.table with timestamp data.}
}
\value{
A simple feature (sf) object with LineString data.
}
\description{
Every interval of GPS data points between stops for each trip_id is
 converted into a linestring segment. The output assumes constant average speed 
 between consecutive stops.
}
\examples{
library(gtfs2gps)
library(magrittr)

poa <- read_gtfs(system.file("extdata/poa.zip", package = "gtfs2gps"))
poa_subset <- gtfstools::filter_by_shape_id(poa, c("T2-1", "A141-1")) \%>\%
  filter_single_trip()

poa_gps <- gtfs2gps(poa_subset)

poa_gps_sf <- gps_as_sflinestring(poa_gps)
}
