% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_stops_to_sf.R
\name{convert_stops_to_sf}
\alias{convert_stops_to_sf}
\title{Convert \code{stops} table to simple feature object}
\usage{
convert_stops_to_sf(gtfs, stop_id = NULL, crs = 4326)
}
\arguments{
\item{gtfs}{A GTFS object.}

\item{stop_id}{A character vector including the \code{stop_id}s to be converted.
If \code{NULL} (the default), all stops are converted.}

\item{crs}{The CRS of the resulting object, either as an EPSG code or as an
\code{crs} object. Defaults to 4326 (WGS 84).}
}
\value{
A \verb{POINT sf} object.
}
\description{
Converts the \code{stops} table to a \verb{POINT sf} object.
}
\examples{
# read gtfs
data_path <- system.file("extdata/spo_gtfs.zip", package = "gtfstools")
gtfs <- read_gtfs(data_path)

stops_sf <- convert_stops_to_sf(gtfs)
head(stops_sf)

stops_sf <- convert_stops_to_sf(gtfs, stop_id = "18848")
stops_sf

}
