% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_merge.R
\name{tbl_merge}
\alias{tbl_merge}
\title{Merge two or more gtsummary regression objects}
\usage{
tbl_merge(tbls, tab_spanner = paste0(c("Model "), seq_len(length(tbls))))
}
\arguments{
\item{tbls}{List of gtsummary regression objects}

\item{tab_spanner}{Character vector specifying the spanning headers.
Must be same length as \code{tbls}argument}
}
\value{
A \code{tbl_merge} object
}
\description{
Merges two or more \code{tbl_regression}, \code{tbl_uvregression}, or \code{tbl_stack}
objects and adds appropriate spanning headers.
}
\section{Example Output}{

\if{html}{\figure{tbl_merge_ex.png}{options: width=70\%}}
}

\examples{
library(survival)
t1 <-
  glm(response ~ trt + grade + age, trial, family = binomial) \%>\%
  tbl_regression(exponentiate = TRUE)
t2 <-
  coxph(Surv(ttdeath, death) ~ trt + grade + age, trial) \%>\%
  tbl_regression(exponentiate = TRUE)
tbl_merge_ex <-
  tbl_merge(
    tbls = list(t1, t2),
    tab_spanner = c("Tumor Response", "Time to Death")
  )
}
\seealso{
\link{tbl_stack}

Other tbl_regression tools: \code{\link{add_global_p.tbl_regression}},
  \code{\link{add_nevent.tbl_regression}},
  \code{\link{bold_italicize_labels_levels}},
  \code{\link{bold_p.tbl_regression}},
  \code{\link{bold_p.tbl_stack}},
  \code{\link{inline_text.tbl_regression}},
  \code{\link{modify_header}},
  \code{\link{sort_p.tbl_regression}},
  \code{\link{tbl_regression}}, \code{\link{tbl_stack}}

Other tbl_uvregression tools: \code{\link{add_global_p.tbl_uvregression}},
  \code{\link{add_nevent.tbl_uvregression}},
  \code{\link{add_q.tbl_uvregression}},
  \code{\link{bold_italicize_labels_levels}},
  \code{\link{bold_p.tbl_stack}},
  \code{\link{bold_p.tbl_uvregression}},
  \code{\link{inline_text.tbl_uvregression}},
  \code{\link{modify_header}},
  \code{\link{sort_p.tbl_uvregression}},
  \code{\link{tbl_stack}}, \code{\link{tbl_uvregression}}
}
\author{
Daniel D. Sjoberg
}
\concept{tbl_regression tools}
\concept{tbl_uvregression tools}
