% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inline_text.R
\name{inline_text.tbl_uvregression}
\alias{inline_text.tbl_uvregression}
\title{Report statistics from regression summary tables inline}
\usage{
\method{inline_text}{tbl_uvregression}(
  x,
  variable,
  level = NULL,
  pattern = "{estimate} ({conf.level*100}\% CI {conf.low}, {conf.high}; {p.value})",
  estimate_fun = x$fmt_fun$estimate,
  pvalue_fun = NULL,
  ...
)
}
\arguments{
\item{x}{Object created from \link{tbl_uvregression}}

\item{variable}{Variable name of statistics to present}

\item{level}{Level of the variable to display for categorical variables.
Default is \code{NULL}, returning the top row in the table for the variable.}

\item{pattern}{String indicating the statistics to return.
Uses \link[glue:glue]{glue::glue} formatting.
Default is \code{"{estimate} ({conf.level }\% CI  {conf.low}, {conf.high}; {p.value})"}.
All columns from \code{x$table_body} are available to print as well as the
confidence level (conf.level). See below for details.}

\item{estimate_fun}{function to style model coefficient estimates.
Columns 'estimate', 'conf.low', and 'conf.high' are formatted.
Default is \code{x$inputs$estimate_fun}}

\item{pvalue_fun}{function to style p-values and/or q-values.
Default is \code{function(x) style_pvalue(x, prepend_p = TRUE)}}

\item{...}{Not used}
}
\value{
A string reporting results from a gtsummary table
}
\description{
Extracts and returns statistics from a table created by the \code{tbl_uvregression}
function for inline reporting in an R markdown document.
Detailed examples in the
\href{http://www.danieldsjoberg.com/gtsummary/articles/inline_text.html}{inline_text vignette}
}
\section{pattern argument}{

The following items are available to print.  Use \code{print(x$table_body)} to
print the table the estimates are extracted from.
\itemize{
\item \code{{estimate}} coefficient estimate formatted with 'estimate_fun'
\item \code{{conf.low}} lower limit of confidence interval formatted with 'estimate_fun'
\item \code{{conf.high}} upper limit of confidence interval formatted with 'estimate_fun'
\item \code{{ci}} confidence interval formatted with x$estimate_fun
\item \code{{p.value}} p-value formatted with 'pvalue_fun'
\item \code{{N}} number of observations in model
\item \code{{label}} variable/variable level label
}
}

\examples{
inline_text_ex1 <-
  trial[c("response", "age", "grade")] \%>\%
  tbl_uvregression(
    method = glm,
    method.args = list(family = binomial),
    y = response,
    exponentiate = TRUE
  )

inline_text(inline_text_ex1, variable = age)
inline_text(inline_text_ex1, variable = grade, level = "III")
}
\seealso{
Other tbl_uvregression tools: 
\code{\link{add_global_p.tbl_uvregression}()},
\code{\link{add_nevent.tbl_uvregression}()},
\code{\link{add_q}()},
\code{\link{bold_italicize_labels_levels}},
\code{\link{modify_footnote}()},
\code{\link{modify_header}()},
\code{\link{modify_spanning_header}()},
\code{\link{tbl_merge}()},
\code{\link{tbl_stack}()},
\code{\link{tbl_uvregression}()}
}
\author{
Daniel D. Sjoberg
}
\concept{tbl_uvregression tools}
