% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_kable_extra.R
\name{as_kable_extra}
\alias{as_kable_extra}
\title{Convert gtsummary object to a kableExtra object}
\usage{
as_kable_extra(
  x,
  include = everything(),
  return_calls = FALSE,
  strip_md_bold = TRUE,
  ...
)
}
\arguments{
\item{x}{Object created by a function from the gtsummary package
(e.g. \link{tbl_summary} or \link{tbl_regression})}

\item{include}{Commands to include in output. Input may be a vector of
quoted or unquoted names. tidyselect and gtsummary select helper
functions are also accepted.
Default is \code{everything()}.}

\item{return_calls}{Logical. Default is \code{FALSE}. If \code{TRUE}, the calls are returned
as a list of expressions.}

\item{strip_md_bold}{When TRUE, all double asterisk (markdown language for
bold weight) in column labels and spanning headers are removed.
Default is TRUE}

\item{...}{Additional arguments passed to \link[knitr:kable]{knitr::kable}}
}
\value{
A {kableExtra} object
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}
Function converts a gtsummary object to a knitr_kable + kableExtra object.
A user can use this function if they wish to add customized formatting
available via \link[knitr:kable]{knitr::kable} and {kableExtra}. Note that {gtsummary}
uses the standard markdown \verb{**} to bold headers, and they may need to be
changed manually with kableExtra output.
}
\examples{
tbl <-
  trial \%>\%
  tbl_summary(by = trt) \%>\%
  as_kable_extra()
}
\seealso{
Other gtsummary output types: 
\code{\link{as_flex_table}()},
\code{\link{as_gt}()},
\code{\link{as_hux_table}()},
\code{\link{as_kable}()},
\code{\link{as_tibble.gtsummary}()}
}
\author{
Daniel D. Sjoberg
}
\concept{gtsummary output types}
