% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vetted_models.R
\name{vetted_models}
\alias{vetted_models}
\title{Vetted tidy models}
\description{
Below is a list of models vetted for use
in \link{tbl_regression} and \link{tbl_uvregression}.  If a model is passed to these
functions and the model is not listed below and  a \code{tidy()} function is
not specified in the \verb{tidy_fun=} argument, the model object will be passed
to \code{broom::tidy} or \code{broom.mixed::tidy}.

\itemize{
\item{\link[stats:lm]{stats::lm}}
\item{\link[stats:glm]{stats::glm}}
\item{\link[survival:coxph]{survival::coxph}}
\item{\link[survival:clogit]{survival::clogit}}
\item{\link[survival:survreg]{survival::survreg}}
\item{\link[lme4:glmer]{lme4::glmer}}
\item{\link[lme4:lmer]{lme4::lmer}}
\item{\link[geepack:geeglm]{geepack::geeglm}}
}
}
\section{model support}{

If \code{broom::tidy} or \code{broom.mixed::tidy} supports a class of model not listed
above, please submit a \href{https://github.com/ddsjoberg/gtsummary/issues}{GitHub Issue}.
The model can be added to the list of vetted models. Unit tests will be
put in place to ensure continued support for the model.
}

\section{custom tidiers}{

In some cases you may need to use a custom function to tidy regression model
results. A user may pass a custom tidier function to \link{tbl_regression} and
\link{tbl_uvregression} in the \verb{tidy_fun=} argument.  The function passed, however,
must be a proper tidier.  For example, it must return a tibble that is one
line per variable in the regression model; it must accept arguments
\verb{exponentiate=}, \verb{conf.level=}, and \verb{conf.int=} since these arguments will
be passed to the function internally (we recommend including \code{...} to
capture any arguments you may not need). See below for an example where the
confidence limits for a linear regression model are calculated using Wald's method.
}

\examples{
my_tidy <- function(x, exponentiate = FALSE, conf.level = 0.95, ...) {
  tidy <-
    dplyr::bind_cols(
      broom::tidy(x, conf.int = FALSE),
      # calculate the confidence intervals, and save them in a tibble
      stats::confint.default(x) \%>\%
        tibble::as_tibble() \%>\%
        rlang::set_names(c("conf.low", "conf.high"))
    )
  # exponentiating, if requested
  if (exponentiate == TRUE)
    tidy <- dplyr::mutate_at(vars(estimate, conf.low, conf.high), exp)
  tidy
}

lm(age ~ grade + response, trial) \%>\%
  my_tidy()
}
\keyword{internal}
