% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_glance.R
\name{add_glance}
\alias{add_glance}
\alias{add_glance_table}
\alias{add_glance_source_note}
\title{Add Model Statistics}
\usage{
add_glance_table(
  x,
  include = everything(),
  label = NULL,
  fmt_fun = NULL,
  glance_fun = NULL
)

add_glance_source_note(
  x,
  include = everything(),
  label = NULL,
  fmt_fun = NULL,
  glance_fun = NULL,
  text_interpret = c("md", "html"),
  sep1 = " = ",
  sep2 = "; "
)
}
\arguments{
\item{x}{'tbl_regression' object}

\item{include}{list of statistics to include in output. Must be column
names of the tibble returned by \code{broom::glance()}. The include argument
can also be used to specify the order the statistics appear in the table.}

\item{label}{List of formulas specifying statistic labels,
e.g. \code{list(r.squared ~ "R2", p.value ~ "P")}}

\item{fmt_fun}{List of formulas where the LHS is a statistic and the RHS
is a function to format/round the statistics. The default is to round
the number of observations and degrees of freedom to the nearest integer,
p-values are styled with \code{style_pvalue()} and the remaining statistics
are styled with \code{style_sigfig(x, digits = 3)}}

\item{glance_fun}{function that returns model statistics. Default is
\code{broom::glance()} for most model obejcts, and
\code{broom::glance(mice::pool())} for MICE 'mira' models.
Custom functions must return a single row tibble.}

\item{text_interpret}{String indicates whether source note text
will be interpreted with
\code{\link[gt:md]{gt::md()}} or \code{\link[gt:html]{gt::html()}}. Must be \code{"md"} (default) or \code{"html"}.}

\item{sep1}{Separator between statistic name and statistic.
Default is \code{" = "}, e.g. \code{"R2 = 0.456"}}

\item{sep2}{Separator between statistics. Default is \code{"; "}}
}
\value{
gtsummary table
}
\description{
Add model statistics returned from \code{broom::glance()}. Statistics can either
be appended to the table (\code{add_glance_table()}), or added as a
table source note (\code{add_glance_source_note()}).
}
\section{Default Labels}{

The following statistics have set default labels when printed.
When there is no default, the column name from \code{broom::glance()} is printed.\tabular{ll}{
   Statistic Name \tab Default Label \cr
   r.squared \tab R² \cr
   adj.r.squared \tab Adjusted R² \cr
   p.value \tab p-value \cr
   logLik \tab Log-likelihood \cr
   statistic \tab Statistic \cr
   df.residual \tab Residual df \cr
   null.deviance \tab Null deviance \cr
   df.null \tab Null df \cr
   nevent \tab N events \cr
   concordance \tab c-index \cr
   std.error.concordance \tab c-index SE \cr
   nobs \tab No. Obs. \cr
   deviance \tab Deviance \cr
   sigma \tab Sigma \cr
}
}

\section{Tips}{

When combining \code{add_glance_table()} with \code{tbl_merge()}, the
ordering of the model terms and the glance statistics may become jumbled.
To re-order the rows with glance statistics on bottom, use the script below:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl_merge(list(tbl1, tbl2)) \%>\%
  modify_table_body(~.x \%>\% arrange(row_type == "glance_statistic"))
}\if{html}{\out{</div>}}
}

\section{Example Output}{

\if{html}{Example 1}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/ddsjoberg/gtsummary/main/man-images/add_glance_ex1.png" alt="image of rendered example table" style="width:35\%;">
}}

\if{html}{Example 2}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/ddsjoberg/gtsummary/main/man-images/add_glance_ex2.png" alt="image of rendered example table" style="width:35\%;">
}}
}

\examples{
\donttest{
mod <- lm(age ~ marker + grade, trial) \%>\% tbl_regression()

# Example 1 ----------------------------------
add_glance_ex1 <-
  mod \%>\%
  add_glance_table(
    label = list(sigma ~ "\U03C3"),
    include = c(r.squared, AIC, sigma)
  )

# Example 2 ----------------------------------
add_glance_ex2 <-
  mod \%>\%
  add_glance_source_note(
    label = list(sigma ~ "\U03C3"),
    include = c(r.squared, AIC, sigma)
  )
}
}
\seealso{
Review \link[=syntax]{list, formula, and selector syntax} used throughout gtsummary
}
